/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client.sp.mongate.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.xunlei.channel.sms.client.sp.mongate.vo.MongateBatchRequest;
import com.xunlei.channel.sms.client.sp.mongate.vo.MongateCallBackMessageResponse;
import com.xunlei.channel.sms.client.sp.mongate.vo.MongateCallbackRequest;
import com.xunlei.channel.sms.client.sp.mongate.vo.MongateMultiContentRequest;
import com.xunlei.channel.sms.client.sp.mongate.vo.MongateMultiContentRequestUnit;
import com.xunlei.channel.sms.constants.SmsStatus;
import com.xunlei.channel.sms.entity.AbstractSmsMessage;
import com.xunlei.channel.sms.entity.MtResult;
import com.xunlei.channel.sms.util.ConvertBeanHelper;
import com.xunlei.channel.sms.util.SequenceGenerator;
import com.xunlei.channel.sms.util.XmlHelper;
import com.xunlei.channel.sms.util.http.ParameteredHttpUtils;
import com.xunlei.channel.sms.vo.MoMessage;
import com.xunlei.channel.sms.vo.MtStatusMessage;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MongateClient {
    private static final Logger logger = LoggerFactory.getLogger(MongateClient.class);
    public static final int RESPONSE_FAIL_MAX_LENGTH = 14;
    public static final int MAX_BATCH_SIZE = 1000;
    public static final int MAX_MULTI_SIZE = 100;
    public static final int MAX_MSG_ID_LENGTH = 18;
    public static final String BATCH_SEND_PATH = "/MWGate/wmgw.asmx/MongateSendSubmit";
    public static final String MULTI_SEND_PATH = "/MWGate/wmgw.asmx/MongateMULTIXSend";
    public static final String QUERY_BALANCE_PATH = "/MWGate/wmgw.asmx/MongateQueryBalance";
    public static final String QUERY_STATUS_PATH = "/MWGate/wmgw.asmx/MongateGetDeliver";
    public static final String REQUEST_TYPE_MO_AND_STATUS = "0";
    public static final int REQUEST_TYPE_MO = 1;
    public static final int REQUEST_TYPE_STATUS = 2;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final int DEFAULT_TIME_OUT = 10000;
    private static final String REGEX = ",";

    public List<MtResult> batchSendWithoutCheckSize(String host, String port, String userId, String password, List<SmsMessage> messages) throws Exception {
        HashSet<String> mobiles = new HashSet<String>();
        for (SmsMessage message : messages) {
            String mobile = message.getMobile();
            if (Strings.isNullOrEmpty((String)mobile)) {
                logger.warn("Empty of mobile in message: {}", (Object)message);
            }
            mobiles.add(mobile);
        }
        String mobilesString = StringUtils.arrayToDelimitedString((Object[])mobiles.toArray(new String[mobiles.size()]), (String)REGEX);
        String msgId = MongateClient.getMsgId(SequenceGenerator.generateSequence());
        MongateBatchRequest mongateBatchSendVo = new MongateBatchRequest();
        mongateBatchSendVo.setUserId(userId);
        mongateBatchSendVo.setPassword(password);
        mongateBatchSendVo.setMobiles(mobilesString);
        mongateBatchSendVo.setMsgId(msgId);
        mongateBatchSendVo.setMobileCount(mobiles.size());
        mongateBatchSendVo.setContent(messages.get(0).getContent());
        String batchSendUrl = MongateClient.getBatchSendUrl(host, port);
        boolean success = this.send(messages, mongateBatchSendVo, batchSendUrl);
        ArrayList<MtResult> mtResults = new ArrayList<MtResult>(messages.size());
        SmsStatus smsStatus = success ? SmsStatus.SUCCESS : SmsStatus.FAIL;
        for (SmsMessage message : messages) {
            MtResult mtResult = MtResult.buildMtResult((SmsMessage)message, (SmsStatus)smsStatus, (String)msgId);
            mtResults.add(mtResult);
        }
        return mtResults;
    }

    public List<MtResult> batchSendMultiplyContentMessages(String host, String port, String userId, String password, Collection<SmsMessage> smsMessages) throws Exception {
        ArrayList<MongateMultiContentRequestUnit> units = new ArrayList<MongateMultiContentRequestUnit>(smsMessages.size());
        for (SmsMessage smsMessage : smsMessages) {
            String mobile = smsMessage.getMobile();
            String content = smsMessage.getContent();
            MongateMultiContentRequestUnit unit = new MongateMultiContentRequestUnit();
            unit.setMobile(mobile);
            unit.setContent(content);
            unit.setMsgId(MongateClient.getMsgId((AbstractSmsMessage)smsMessage));
            units.add(unit);
        }
        MongateMultiContentRequest multiContentRequest = new MongateMultiContentRequest();
        multiContentRequest.setUserId(userId);
        multiContentRequest.setPassword(password);
        multiContentRequest.setUnits(units);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("userId", userId);
        params.put("password", password);
        params.put("multixmt", multiContentRequest.getMultiContentPackage());
        String multiSendUrl = MongateClient.getMultiSendUrl(host, port);
        boolean success = this.sendWithoutUrlEncode(smsMessages, params, multiSendUrl);
        ArrayList<MtResult> mtResults = new ArrayList<MtResult>(smsMessages.size());
        SmsStatus smsStatus = success ? SmsStatus.SUCCESS : SmsStatus.FAIL;
        for (SmsMessage message : smsMessages) {
            MtResult mtResult = MtResult.buildMtResult((SmsMessage)message, (SmsStatus)smsStatus, (String)MongateClient.getMsgId((AbstractSmsMessage)message));
            mtResults.add(mtResult);
        }
        return mtResults;
    }

    public List<MtStatusMessage> getMtStatusMessages(String host, String port, String account, String password, String spClass) throws IOException {
        List<String> responses = this.getCallbackMessages(host, port, account, password, 2);
        ArrayList mtStatusMessages = Lists.newArrayList();
        for (String response : responses) {
            MtStatusMessage mtStatusMessage;
            String[] fieldNames;
            String[] fieldValues = response.split(REGEX);
            HashMap responsesMap = Maps.newHashMap();
            int i = 0;
            for (String fieldName : fieldNames = new String[]{"iReqType", "receiveTime", "spMessageId", "channelNumber", "mobile", "msgId", "ext", "smsStatus", "result"}) {
                int tmp;
                if ((tmp = i++) >= fieldValues.length) {
                    logger.error("error message :The length of fields from getCallbackMessages is less than actual fields");
                    break;
                }
                responsesMap.put(fieldName, fieldValues[tmp]);
            }
            if ((mtStatusMessage = (MtStatusMessage)ConvertBeanHelper.convertMapByClass((Map)responsesMap, MtStatusMessage.class)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("mtStatusMessage : is null ");
                }
                return mtStatusMessages;
            }
            mtStatusMessage.setSpClass(spClass);
            mtStatusMessage.setSpMessageId(mtStatusMessage.buildSpMessageId(mtStatusMessage.getMsgId()));
            if (REQUEST_TYPE_MO_AND_STATUS.equals(mtStatusMessage.getSmsStatus())) {
                mtStatusMessage.setSmsStatus(SmsStatus.TOUCH.getStatus());
            } else {
                mtStatusMessage.setSmsStatus(SmsStatus.NO_TOUCH.getStatus());
            }
            mtStatusMessages.add(mtStatusMessage);
        }
        return mtStatusMessages;
    }

    public List<MoMessage> getMoMessages(String host, String port, String account, String password, String spId) throws IOException {
        List<String> responses = this.getCallbackMessages(host, port, account, password, 1);
        ArrayList moMessages = Lists.newArrayList();
        for (String response : responses) {
            MoMessage moMessage;
            String[] fieldNames;
            String[] fieldValues = response.split(REGEX);
            HashMap responsesMap = Maps.newHashMap();
            int i = 0;
            for (String fieldName : fieldNames = new String[]{"iReqType", "receiveTime", "mobile", "spMessageId", "ext", "moStatus", "content"}) {
                int tmp;
                if ((tmp = i++) >= fieldValues.length) {
                    logger.error("error message :The length of fields from getMoMessages is less than actual fields");
                    break;
                }
                responsesMap.put(fieldName, fieldValues[tmp]);
            }
            if ((moMessage = (MoMessage)ConvertBeanHelper.convertMapByClass((Map)responsesMap, MoMessage.class)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("mtStatusMessage : is null ");
                }
                return moMessages;
            }
            moMessage.setSpId(spId);
            moMessages.add(moMessage);
        }
        return moMessages;
    }

    private List<String> getCallbackMessages(String host, String port, String userId, String password, int iReqType) throws IOException {
        String url = MongateClient.getQueryStatusUrl(host, port);
        Assert.notNull((Object)url, (String)"url could'nt be null!");
        Assert.notNull((Object)userId, (String)"userId could'nt be null!");
        Assert.notNull((Object)password, (String)"password could'nt be null!");
        Assert.notNull((Object)iReqType, (String)"iReqType could'nt be null!");
        MongateCallbackRequest mongateCallbackRequest = new MongateCallbackRequest();
        mongateCallbackRequest.setUserId(userId);
        mongateCallbackRequest.setiReqType(iReqType);
        mongateCallbackRequest.setPassword(password);
        String response = ParameteredHttpUtils.doPost((Object)mongateCallbackRequest, (String)url, (String)DEFAULT_CHARSET, (int)10000);
        if (logger.isDebugEnabled()) {
            logger.debug("Got response: {} with url: {} and paramsEntity: {}", new Object[]{response, url, mongateCallbackRequest});
        }
        List<String> responeses = MongateClient.parseCallBackResponse(response);
        return responeses;
    }

    private static List<String> parseCallBackResponse(String response) throws IOException {
        MongateCallBackMessageResponse mongateCallBackMessageResponse = (MongateCallBackMessageResponse)XmlHelper.convertXmlByClass((String)response, MongateCallBackMessageResponse.class);
        Assert.notNull((Object)mongateCallBackMessageResponse, (String)"mongateCallBackMessageResponse could'nt be null");
        Optional reponses = Optional.fromNullable(mongateCallBackMessageResponse.getMongateCallBackResults());
        if (!reponses.isPresent() && logger.isDebugEnabled()) {
            logger.debug("reponses is null");
            return Lists.newArrayList();
        }
        return (List)reponses.get();
    }

    protected boolean send(Collection<SmsMessage> messages, Object paramsEntity, String url) throws UnsupportedEncodingException {
        String response = ParameteredHttpUtils.doPost((Object)paramsEntity, (String)url, (String)DEFAULT_CHARSET, (int)10000);
        if (logger.isDebugEnabled()) {
            logger.debug("Got response: {} with url: {} and paramsEntity: {}", new Object[]{response, url, paramsEntity});
        }
        return this.parseResponse(messages, response);
    }

    protected boolean sendWithoutUrlEncode(Collection<SmsMessage> messages, Map<String, String> paramsEntity, String url) throws UnsupportedEncodingException {
        if (paramsEntity == null) {
            return false;
        }
        String response = ParameteredHttpUtils.doPost(paramsEntity, (String)url, (String)DEFAULT_CHARSET, (int)10000);
        if (logger.isDebugEnabled()) {
            logger.debug("Got response: {} with url: {} and paramsEntity: {}", new Object[]{response, url, paramsEntity});
        }
        return this.parseResponse(messages, response);
    }

    private boolean parseResponse(Collection<SmsMessage> messages, String response) {
        try {
            String responses = MongateClient.parseResponse(response);
            if (Strings.isNullOrEmpty((String)responses)) {
                MongateClient.updateResult(messages, "Null result");
                return false;
            }
            if (responses.length() <= 14) {
                MongateClient.updateResult(messages, responses);
                logger.error("Error send messages by mongate, result: {}", (Object)responses);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            logger.error("Error send messages, message: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static List<MtResult> buildMtResults(Collection<SmsMessage> messages, SmsStatus status) {
        ArrayList<MtResult> mtResults = new ArrayList<MtResult>(messages.size());
        for (SmsMessage message : messages) {
            MtResult mtResult = MtResult.buildMtResult((SmsMessage)message, (SmsStatus)status, (String)MongateClient.getMsgId(message.getUniqueNumber()));
            mtResults.add(mtResult);
        }
        return mtResults;
    }

    private static <T extends AbstractSmsMessage> void updateResult(Collection<T> messages, String result) {
        if (CollectionUtils.isEmpty(messages)) {
            return;
        }
        for (AbstractSmsMessage message : messages) {
            message.setResult(result);
        }
    }

    public static String getMsgId(AbstractSmsMessage messageRequest) {
        String uniqueNumber = messageRequest == null || messageRequest.getUniqueNumber() == null ? SequenceGenerator.generateSequence() : messageRequest.getUniqueNumber();
        return MongateClient.getMsgId(uniqueNumber);
    }

    public static String getMsgId(String uniqueNumber) {
        if (uniqueNumber == null) {
            uniqueNumber = SequenceGenerator.generateSequence();
        }
        if (uniqueNumber.length() > 18) {
            try {
                long timeStamp = SequenceGenerator.getTimeStamp((String)uniqueNumber);
                int machineNumber = HashCode.fromString((String)SequenceGenerator.getMachineNumberBySequence((String)uniqueNumber)).asInt();
                String index = SequenceGenerator.getIndex((String)uniqueNumber);
                uniqueNumber = timeStamp + (long)machineNumber + index;
                if (logger.isDebugEnabled()) {
                    logger.debug("Build msgId. timestamp: {} machineNumber: {} index: {} result: {}", new Object[]{timeStamp, machineNumber, index, uniqueNumber});
                }
            }
            catch (ParseException e) {
                logger.error("", (Throwable)e);
            }
        }
        try {
            return "" + Long.parseLong(uniqueNumber);
        }
        catch (NumberFormatException e) {
            return uniqueNumber;
        }
    }

    public static String getBatchSendUrl(String host, String port) {
        return MongateClient.buildUrl(host, port, BATCH_SEND_PATH);
    }

    public static String getMultiSendUrl(String host, String port) {
        return MongateClient.buildUrl(host, port, MULTI_SEND_PATH);
    }

    public static String getQueryBalanceUrl(String host, String port) {
        return MongateClient.buildUrl(host, port, QUERY_BALANCE_PATH);
    }

    public static String getQueryStatusUrl(String host, String port) {
        return MongateClient.buildUrl(host, port, QUERY_STATUS_PATH);
    }

    private static String buildUrl(String host, String port, String path) {
        StringBuilder builder = new StringBuilder("http://");
        builder.append(host);
        builder.append(":");
        builder.append(port);
        if (!path.startsWith("/")) {
            builder.append("/");
        }
        builder.append(path);
        return builder.toString();
    }

    protected static String parseResponse(String response) throws IOException {
        XmlMapper xmlMapper = new XmlMapper();
        JsonNode jsonNode = xmlMapper.readTree(response);
        Iterator stringIterator = jsonNode.fieldNames();
        while (stringIterator.hasNext()) {
            String next = (String)stringIterator.next();
            JsonNode nodeValue = jsonNode.get(next);
            if (!nodeValue.getNodeType().equals((Object)JsonNodeType.STRING)) continue;
            return nodeValue.textValue();
        }
        return null;
    }
}

