/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client.sp.mongate;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.xunlei.channel.sms.client.AbstractBatchModeSpClient;
import com.xunlei.channel.sms.client.SpNotSupportModeException;
import com.xunlei.channel.sms.client.constant.SpBatchMode;
import com.xunlei.channel.sms.client.sp.mongate.client.MongateClient;
import com.xunlei.channel.sms.entity.MtResult;
import com.xunlei.channel.sms.entity.SpInfo;
import com.xunlei.channel.sms.util.PatternUtils;
import com.xunlei.channel.sms.vo.MoMessage;
import com.xunlei.channel.sms.vo.MtStatusMessage;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MongateSpClient
extends AbstractBatchModeSpClient {
    private static final Logger logger = LoggerFactory.getLogger(MongateSpClient.class);
    private MongateClient mongateClient = new MongateClient();

    @Override
    public String spClass() {
        return "mongate";
    }

    @Override
    protected int maxSameContentBatchSize() {
        return 1000;
    }

    @Override
    protected int maxDifferentContentBatchSize() {
        return 100;
    }

    @Override
    protected SpBatchMode[] supportBatchModes() {
        return new SpBatchMode[]{SpBatchMode.SAME_CONTENT, SpBatchMode.DIFFERENT_CONTENT};
    }

    @Override
    protected MtResult singleSend(SpInfo spInfo, SmsMessage message) {
        throw new SpNotSupportModeException();
    }

    @Override
    protected List<MtResult> sendMultiplyContents(SpInfo spInfo, List<SmsMessage> messages) {
        String account = spInfo.getAccount();
        String password = spInfo.getPassword();
        String apiUrl = spInfo.getApiUrl();
        String[] hostAndPort = PatternUtils.getHostAndPort((String)apiUrl);
        if (hostAndPort == null || hostAndPort.length != 2) {
            logger.error("Not found available api url config! apiUrl is: {}", (Object)apiUrl);
            return Arrays.asList(MtResult.errorResult());
        }
        String host = hostAndPort[0];
        String port = hostAndPort[1];
        try {
            return this.mongateClient.batchSendMultiplyContentMessages(host, port, account, password, messages);
        }
        catch (Exception e) {
            logger.error("Error when send message: " + messages + ". ERROR: " + e.getMessage(), (Throwable)e);
            return Arrays.asList(MtResult.errorResult());
        }
    }

    @Override
    protected List<MtResult> sendSameContentWithMobiles(SpInfo spInfo, List<SmsMessage> messages) {
        String account = spInfo.getAccount();
        String password = spInfo.getPassword();
        String apiUrl = spInfo.getApiUrl();
        String[] hostAndPort = PatternUtils.getHostAndPort((String)apiUrl);
        if (hostAndPort == null || hostAndPort.length != 2) {
            logger.error("Not found available api url config! apiUrl is: {}", (Object)apiUrl);
            return Arrays.asList(MtResult.errorResult());
        }
        String host = hostAndPort[0];
        String port = hostAndPort[1];
        try {
            return this.mongateClient.batchSendWithoutCheckSize(host, port, account, password, messages);
        }
        catch (Exception e) {
            logger.error("Error when send message: " + messages + ". ERROR: " + e.getMessage(), (Throwable)e);
            return Arrays.asList(MtResult.errorResult());
        }
    }

    @Override
    public List<MtStatusMessage> getMtStatusMessages(String spId) {
        Optional<SpInfo> spInfoBySpId = this.getSpInfoBySpId(spId);
        if (!spInfoBySpId.isPresent()) {
            logger.error("Not found available for spId: {}", (Object)spId);
            return null;
        }
        SpInfo spInfo = (SpInfo)spInfoBySpId.get();
        String account = spInfo.getAccount();
        String password = spInfo.getPassword();
        String apiUrl = spInfo.getApiUrl();
        String spClass = spInfo.getSpClass();
        String[] hostAndPort = PatternUtils.getHostAndPort((String)apiUrl);
        if (hostAndPort == null || hostAndPort.length != 2) {
            logger.error("Not found available api url config! apiUrl is: {}", (Object)apiUrl);
            return null;
        }
        String host = hostAndPort[0];
        String port = hostAndPort[1];
        List<Object> mtStatusMessages = Lists.newArrayList();
        try {
            mtStatusMessages = this.mongateClient.getMtStatusMessages(host, port, account, password, spClass);
        }
        catch (IOException e) {
            logger.error("Failed to getMtStatusMessages with message: " + e.getMessage(), (Throwable)e);
        }
        return mtStatusMessages;
    }

    @Override
    public List<MoMessage> getMoMessages(String spId) {
        Optional<SpInfo> spInfoBySpId = this.getSpInfoBySpId(spId);
        if (!spInfoBySpId.isPresent()) {
            logger.error("Not found available for spId: {}", (Object)spId);
            return null;
        }
        SpInfo spInfo = (SpInfo)spInfoBySpId.get();
        String account = spInfo.getAccount();
        String password = spInfo.getPassword();
        String apiUrl = spInfo.getApiUrl();
        String[] hostAndPort = PatternUtils.getHostAndPort((String)apiUrl);
        if (hostAndPort == null || hostAndPort.length != 2) {
            logger.error("Not found available api url config! apiUrl is: {}", (Object)apiUrl);
            return null;
        }
        String host = hostAndPort[0];
        String port = hostAndPort[1];
        List<Object> moMessages = Lists.newArrayList();
        try {
            moMessages = this.mongateClient.getMoMessages(host, port, account, password, spId);
        }
        catch (IOException e) {
            logger.error("Failed to getMtStatusMessages with message: " + e.getMessage(), (Throwable)e);
        }
        return moMessages;
    }
}

