/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client.sp.mock;

import com.google.common.collect.Lists;
import com.xunlei.channel.sms.client.BatchMtSpClient;
import com.xunlei.channel.sms.entity.MtResult;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.entity.SpInfo;
import com.xunlei.channel.sms.vo.MoMessage;
import com.xunlei.channel.sms.vo.MtStatusMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MockClient
extends BatchMtSpClient {
    private static final Logger logger = LoggerFactory.getLogger(MockClient.class);
    public static final String SP_CLASS = "mock";

    @Override
    public String spClass() {
        return SP_CLASS;
    }

    @Override
    public List<MtStatusMessage> getMtStatusMessages(String spId) {
        return null;
    }

    @Override
    public List<MoMessage> getMoMessages(String spId) {
        return null;
    }

    @Override
    protected int maxBatchSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected Map<SmsMessageRequest, List<MtResult>> batchSendSmsMessageAndReturnStatus(SpInfo spInfo, List<SmsMessageRequest> messages) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.warn("Succeed send messages by mock, requests: {}", messages);
        HashMap<SmsMessageRequest, List<MtResult>> statusMap = new HashMap<SmsMessageRequest, List<MtResult>>();
        for (SmsMessageRequest message : messages) {
            statusMap.put(message, Lists.newArrayList((Object[])new MtResult[]{new MtResult()}));
        }
        return statusMap;
    }
}

