/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client.sp.guodu.client;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xunlei.channel.sms.client.sp.guodu.vo.GuoDuMessageRequest;
import com.xunlei.channel.sms.client.sp.guodu.vo.GuoDuMtStatus;
import com.xunlei.channel.sms.constants.SmsStatus;
import com.xunlei.channel.sms.entity.AbstractSmsMessage;
import com.xunlei.channel.sms.entity.MtResult;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.support.SpMessageUtils;
import com.xunlei.channel.sms.util.http.ParameteredHttpUtils;
import com.xunlei.channel.sms.vo.MoMessage;
import com.xunlei.channel.sms.vo.MtStatusMessage;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class GuoDuClient {
    public static final String MOBILES_DELIMITER = ",";
    public static final String RESPONSE_DELIMITER = ",";
    public static final String CONTENT_ENCODE_CHARSET = "GBK";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final int DEFAULT_TIME_OUT = 10000;
    private static final Logger logger = LoggerFactory.getLogger(GuoDuClient.class);
    public static final int MAX_BATCH_SIZE = 500;

    public List<MtResult> batchSendWithoutCheckSize(String url, String userId, String password, SmsMessageRequest messageRequest, Collection<SmsMessage> messages) throws Exception {
        return this.batchSendWithoutCheckSize(url, userId, password, messageRequest.getContent(), messages);
    }

    public List<MtResult> batchSendWithoutCheckSize(String url, String userId, String password, String content, Collection<SmsMessage> messages) throws Exception {
        List<String> mobiles = this.getMobiles(messages);
        String mobilesString = StringUtils.arrayToDelimitedString((Object[])mobiles.toArray(new String[mobiles.size()]), (String)",");
        String encodedContent = GuoDuClient.getEncodedContent(content);
        GuoDuMessageRequest guoDuMessageRequest = new GuoDuMessageRequest();
        guoDuMessageRequest.setUserId(userId);
        guoDuMessageRequest.setPassword(password);
        guoDuMessageRequest.setMobile(mobilesString);
        guoDuMessageRequest.setContent(encodedContent);
        guoDuMessageRequest.setAppendId("");
        guoDuMessageRequest.setSendTime("");
        return this.send(messages, guoDuMessageRequest, url);
    }

    public List<MtResult> batchSendWithMultiContentWithoutCheckSize(String url, String userId, String password, List<SmsMessage> messages) throws Exception {
        ArrayList mtResults = Lists.newArrayList();
        if (messages.size() == 1) {
            return this.batchSendWithoutCheckSize(url, userId, password, messages.get(0).getContent(), messages);
        }
        Collection removedDuplicateMobileAndContentCollection = SpMessageUtils.getRemovedDuplicateMobileAndContentSet(messages);
        Collection duplicateMobileAndContentMap = SpMessageUtils.getDuplicateMobileRequests((Collection)removedDuplicateMobileAndContentCollection);
        for (SmsMessage messageRequest : duplicateMobileAndContentMap) {
            mtResults.addAll(this.batchSendWithMultiContentWithoutCheckSize(url, userId, password, Arrays.asList(messageRequest)));
        }
        if (CollectionUtils.isEmpty((Collection)removedDuplicateMobileAndContentCollection)) {
            return mtResults;
        }
        ArrayList<String> mobiles = new ArrayList<String>(removedDuplicateMobileAndContentCollection.size());
        ArrayList<String> contents = new ArrayList<String>(removedDuplicateMobileAndContentCollection.size());
        for (SmsMessage smsMessageRequest : removedDuplicateMobileAndContentCollection) {
            String mobile = smsMessageRequest.getMobile();
            String content = smsMessageRequest.getContent();
            mobiles.add(mobile);
            contents.add(content);
        }
        String mobilesString = StringUtils.arrayToDelimitedString((Object[])mobiles.toArray(new String[mobiles.size()]), (String)",");
        String contentsString = GuoDuClient.getContents(contents);
        if (Strings.isNullOrEmpty((String)contentsString)) {
            logger.error("messages: {} has no content!", messages);
            GuoDuClient.updateResult(messages, "No content found!");
            return mtResults;
        }
        GuoDuMessageRequest guoDuMessageRequest = new GuoDuMessageRequest();
        guoDuMessageRequest.setUserId(userId);
        guoDuMessageRequest.setPassword(password);
        guoDuMessageRequest.setMobile(mobilesString);
        guoDuMessageRequest.setContent(contentsString);
        return this.send(messages, guoDuMessageRequest, url);
    }

    public List<MtStatusMessage> getMtStatusMessages() {
        return null;
    }

    public List<MoMessage> getMoMessages() {
        return null;
    }

    protected <T extends AbstractSmsMessage> List<MtResult> send(Collection<T> messages, Object paramsEntity, String url) throws UnsupportedEncodingException {
        boolean success;
        String response = ParameteredHttpUtils.doPost((Object)paramsEntity, (String)url, (String)DEFAULT_CHARSET, (int)10000);
        if (logger.isDebugEnabled()) {
            logger.debug("Got response: {} with url: {} and paramsEntity: {}", new Object[]{response, url, paramsEntity});
        }
        if (success = this.parseResponse(messages, response)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Succeed to send request: {} and response is: {}", paramsEntity, (Object)response);
            }
            String spBatchId = this.parseBatchMessageId(response);
            return MtResult.buildMtResult((List)((List)messages), (SmsStatus)SmsStatus.SUCCESS, (String)spBatchId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Failed to send request: {} and response is: {}", paramsEntity, (Object)response);
        }
        return MtResult.buildMtResult((List)((List)messages), (SmsStatus)SmsStatus.FAIL, null);
    }

    private <T extends AbstractSmsMessage> boolean parseResponse(Collection<T> messages, String response) {
        if (Strings.isNullOrEmpty((String)response)) {
            return false;
        }
        String[] split = response.split(",");
        String code = split[0];
        GuoDuMtStatus status = GuoDuMtStatus.getStatus(code);
        if (status == null) {
            GuoDuClient.updateResult(messages, code);
            return false;
        }
        if (status.isSuccess()) {
            return true;
        }
        String message = status.getMessage();
        GuoDuClient.updateResult(messages, message);
        return false;
    }

    private String parseBatchMessageId(String response) {
        String[] split = response.split(",");
        if (split.length >= 2) {
            return split[1];
        }
        return null;
    }

    private static <T extends AbstractSmsMessage> void updateResult(Collection<T> messages, String result) {
        if (CollectionUtils.isEmpty(messages)) {
            return;
        }
        for (AbstractSmsMessage message : messages) {
            message.setResult(result);
        }
    }

    private static String getContents(List<String> contents) throws UnsupportedEncodingException {
        if (CollectionUtils.isEmpty(contents)) {
            return null;
        }
        if (contents.size() == 1) {
            return contents.iterator().next();
        }
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = contents.iterator();
        while (iterator.hasNext()) {
            String content = iterator.next();
            String encodedContent = GuoDuClient.getEncodedContent(content);
            builder.append(encodedContent);
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    private static String getEncodedContent(String content) throws UnsupportedEncodingException {
        return URLEncoder.encode(content, CONTENT_ENCODE_CHARSET);
    }

    private List<String> getMobiles(Collection<SmsMessage> messages) {
        ArrayList<String> mobiles = new ArrayList<String>();
        for (SmsMessage message : messages) {
            String mobile = message.getMobile();
            if (Strings.isNullOrEmpty((String)mobile)) {
                logger.warn("Empty of mobile in message: {}", (Object)message);
            }
            mobiles.add(mobile);
        }
        return mobiles;
    }

    private Set<String> getMobileSet(Collection<SmsMessageRequest> messages) {
        HashSet<String> mobiles = new HashSet<String>();
        for (SmsMessageRequest message : messages) {
            String mobile = message.getMobile();
            if (Strings.isNullOrEmpty((String)mobile)) {
                logger.warn("Empty of mobile in message: {}", (Object)message);
            }
            mobiles.add(mobile);
        }
        return mobiles;
    }
}

