/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client.sp.guodu;

import com.google.common.collect.Lists;
import com.xunlei.channel.sms.client.AbstractBatchModeSpClient;
import com.xunlei.channel.sms.client.SpNotSupportModeException;
import com.xunlei.channel.sms.client.constant.SpBatchMode;
import com.xunlei.channel.sms.client.sp.guodu.client.GuoDuClient;
import com.xunlei.channel.sms.entity.MtResult;
import com.xunlei.channel.sms.entity.SpInfo;
import com.xunlei.channel.sms.vo.MoMessage;
import com.xunlei.channel.sms.vo.MtStatusMessage;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuoDuSpClient
extends AbstractBatchModeSpClient {
    private static final Logger logger = LoggerFactory.getLogger(GuoDuSpClient.class);
    private GuoDuClient guoDuClient = new GuoDuClient();

    @Override
    public String spClass() {
        return "guodu";
    }

    @Override
    protected int maxSameContentBatchSize() {
        return 500;
    }

    @Override
    protected int maxDifferentContentBatchSize() {
        return 500;
    }

    @Override
    protected SpBatchMode[] supportBatchModes() {
        return new SpBatchMode[]{SpBatchMode.DIFFERENT_CONTENT, SpBatchMode.SAME_CONTENT};
    }

    @Override
    protected MtResult singleSend(SpInfo spInfo, SmsMessage message) {
        throw new SpNotSupportModeException();
    }

    @Override
    protected List<MtResult> sendMultiplyContents(SpInfo spInfo, List<SmsMessage> messages) {
        String account = spInfo.getAccount();
        String password = spInfo.getPassword();
        String apiUrl = spInfo.getApiUrl();
        try {
            return this.guoDuClient.batchSendWithMultiContentWithoutCheckSize(apiUrl, account, password, messages);
        }
        catch (Exception e) {
            logger.error("Error when send message: " + messages + ". ERROR: " + e.getMessage(), (Throwable)e);
            return Arrays.asList(MtResult.errorResult());
        }
    }

    @Override
    protected List<MtResult> sendSameContentWithMobiles(SpInfo spInfo, List<SmsMessage> messages) {
        String account = spInfo.getAccount();
        String password = spInfo.getPassword();
        String apiUrl = spInfo.getApiUrl();
        String content = messages.get(0).getContent();
        try {
            return this.guoDuClient.batchSendWithoutCheckSize(apiUrl, account, password, content, messages);
        }
        catch (Exception e) {
            logger.error("Error when send message: " + messages + ". ERROR: " + e.getMessage(), (Throwable)e);
            return Arrays.asList(MtResult.errorResult());
        }
    }

    @Override
    public List<MtStatusMessage> getMtStatusMessages(String spId) {
        ArrayList mtStatusMessages = Lists.newArrayList();
        return mtStatusMessages;
    }

    @Override
    public List<MoMessage> getMoMessages(String spId) {
        ArrayList moMessages = Lists.newArrayList();
        return moMessages;
    }
}

