/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client.sp.arcsoft.client;

import com.xunlei.channel.sms.client.sp.arcsoft.vo.ArcSoftMessageRequest;
import com.xunlei.channel.sms.client.sp.arcsoft.vo.ArcSoftMessageResponse;
import com.xunlei.channel.sms.client.sp.arcsoft.vo.ArcSoftMessageResult;
import com.xunlei.channel.sms.constants.SmsStatus;
import com.xunlei.channel.sms.entity.MtResult;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.util.DateUtils;
import com.xunlei.channel.sms.util.JacksonHelper;
import com.xunlei.channel.sms.util.SequenceGenerator;
import com.xunlei.channel.sms.util.http.HttpParameterHandler;
import com.xunlei.channel.sms.util.http.ParameteredHttpUtils;
import com.xunlei.channel.sms.util.sign.SignUtils;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ArcSoftClient {
    private static final Logger logger = LoggerFactory.getLogger(ArcSoftClient.class);
    private static final String API_TYPE = "1";
    private static final String VERSION = "1.0";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final String MERC_KEY = "merc_key";
    private HttpParameterHandler<ArcSoftMessageRequest> arcSoftMessageRequestHttpParameterHandler = new HttpParameterHandler(ArcSoftMessageRequest.class);

    public List<MtResult> sendMessage(String url, String merchantId, String merchantKey, String appId, SmsMessageRequest messageRequest) throws Exception {
        Assert.notNull((Object)messageRequest, (String)"messageRequest could'nt be null");
        List smsMessages = messageRequest.getSmsMessages();
        return this.sendMessages(url, merchantId, merchantKey, appId, smsMessages);
    }

    public List<MtResult> sendMessages(String url, String merchantId, String merchantKey, String appId, List<SmsMessage> smsMessages) throws IOException {
        Assert.notEmpty(smsMessages, (String)"smsMessages could'nt be null");
        String mobiles = this.mergeMobiles(smsMessages);
        Assert.notNull((Object)mobiles, (String)"mobiles could'nt be null");
        SmsMessage message = smsMessages.get(0);
        if (logger.isDebugEnabled()) {
            logger.debug("Batch send message: {}", smsMessages);
        }
        ArcSoftMessageRequest arcSoftMessageRequest = new ArcSoftMessageRequest();
        arcSoftMessageRequest.setMobile(mobiles);
        arcSoftMessageRequest.setContent(message.getContent());
        arcSoftMessageRequest.setTime(DateUtils.getUnixTime() + "");
        arcSoftMessageRequest.setMerchantId(merchantId);
        arcSoftMessageRequest.setAppId(appId);
        String taskId = this.generateBatchId();
        arcSoftMessageRequest.setAppOid(taskId);
        arcSoftMessageRequest.setApiType(API_TYPE);
        arcSoftMessageRequest.setVersion(VERSION);
        Map parameterMap = this.arcSoftMessageRequestHttpParameterHandler.getParameterMap((Object)arcSoftMessageRequest);
        parameterMap.put(MERC_KEY, merchantKey);
        String signMsg = SignUtils.sign((Map)parameterMap, null, null, (String)DEFAULT_CHARSET, (boolean)true);
        arcSoftMessageRequest.setSignMsg(signMsg.toLowerCase());
        String response = ParameteredHttpUtils.doPost(this.arcSoftMessageRequestHttpParameterHandler, (Object)arcSoftMessageRequest, (String)url, (String)DEFAULT_CHARSET, (int)10000);
        boolean success = this.parseResponse(response, smsMessages);
        if (success) {
            if (logger.isDebugEnabled()) {
                logger.debug("Succeed to send request: {} and response is: {}", (Object)arcSoftMessageRequest, (Object)response);
            }
            return MtResult.buildMtResult(smsMessages, (SmsStatus)SmsStatus.SUCCESS, (String)taskId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Failed to send request: {} and response is: {}", (Object)arcSoftMessageRequest, (Object)response);
        }
        return MtResult.buildMtResult(smsMessages, (SmsStatus)SmsStatus.FAIL, (String)taskId);
    }

    private boolean parseResponse(String response, List<SmsMessage> smsMessages) throws IOException {
        ArcSoftMessageResponse arcSoftMessageResponse = (ArcSoftMessageResponse)JacksonHelper.convertJsonByClass((String)response, ArcSoftMessageResponse.class);
        boolean statusSuccess = arcSoftMessageResponse.isStatusSuccess();
        if (statusSuccess) {
            ArcSoftMessageResult result = arcSoftMessageResponse.getResult();
            if (result == null) {
                return false;
            }
            boolean success = result.isSuccess();
            if (!success) {
                for (SmsMessage smsMessage : smsMessages) {
                    smsMessage.setResult(result.getCodeDesc());
                }
                return false;
            }
            return true;
        }
        for (SmsMessage smsMessage : smsMessages) {
            smsMessage.setResult(arcSoftMessageResponse.getMessage());
        }
        return false;
    }

    protected String generateBatchId() {
        String sequence = SequenceGenerator.generateSequence((int)100000);
        return sequence;
    }

    private String mergeMobiles(List<SmsMessage> smsMessages) {
        String delimiter = "";
        StringBuffer mobiles = new StringBuffer();
        for (SmsMessage smsMessage : smsMessages) {
            mobiles.append(delimiter).append(smsMessage.getMobile());
            delimiter = ",";
        }
        return mobiles.toString();
    }
}

