/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client.sp.arcsoft;

import com.google.common.collect.Lists;
import com.xunlei.channel.sms.client.AbstractBatchModeSpClient;
import com.xunlei.channel.sms.client.SpNotSupportModeException;
import com.xunlei.channel.sms.client.constant.SpBatchMode;
import com.xunlei.channel.sms.client.sp.arcsoft.client.ArcSoftClient;
import com.xunlei.channel.sms.entity.MtResult;
import com.xunlei.channel.sms.entity.SpInfo;
import com.xunlei.channel.sms.vo.MoMessage;
import com.xunlei.channel.sms.vo.MtStatusMessage;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArcSoftSpClient
extends AbstractBatchModeSpClient {
    private static final Logger logger = LoggerFactory.getLogger(ArcSoftSpClient.class);
    private ArcSoftClient arcSoftClient;
    private AtomicInteger j = new AtomicInteger();

    public ArcSoftSpClient() {
        this.arcSoftClient = new ArcSoftClient();
    }

    @Override
    public String spClass() {
        return "arcsoft";
    }

    @Override
    protected int maxSameContentBatchSize() {
        return 2000;
    }

    @Override
    protected int maxDifferentContentBatchSize() {
        return 0;
    }

    @Override
    protected SpBatchMode[] supportBatchModes() {
        return new SpBatchMode[]{SpBatchMode.SAME_CONTENT};
    }

    @Override
    protected MtResult singleSend(SpInfo spInfo, SmsMessage message) {
        throw new SpNotSupportModeException();
    }

    @Override
    protected List<MtResult> sendMultiplyContents(SpInfo spInfo, List<SmsMessage> messages) {
        throw new SpNotSupportModeException();
    }

    @Override
    protected List<MtResult> sendSameContentWithMobiles(SpInfo spInfo, List<SmsMessage> messages) {
        String apiUrl = spInfo.getApiUrl();
        String account = spInfo.getAccount();
        String password = spInfo.getPassword();
        String appId = spInfo.getExt1();
        try {
            List<MtResult> results = this.arcSoftClient.sendMessages(apiUrl, account, password, appId, messages);
            return results;
        }
        catch (IOException e) {
            logger.error("Error when send message: " + messages + ". ERROR: " + e.getMessage(), (Throwable)e);
            return Arrays.asList(MtResult.errorResult());
        }
    }

    @Override
    public List<MtStatusMessage> getMtStatusMessages(String spId) {
        ArrayList mtStatusMessages = Lists.newArrayList();
        return mtStatusMessages;
    }

    @Override
    public List<MoMessage> getMoMessages(String spId) {
        ArrayList moMessages = Lists.newArrayList();
        return moMessages;
    }
}

