/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client.manager.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.xunlei.channel.sms.client.SpClient;
import com.xunlei.channel.sms.client.manager.SpClientManager;
import com.xunlei.channel.sms.entity.SpInfo;
import com.xunlei.channel.sms.mt.MtStatusCallback;
import com.xunlei.channel.sms.service.SpInfoService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class SpClientManagerImpl
implements SpClientManager,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(SpClientManagerImpl.class);
    private Collection<SpClient> spClients;
    @Autowired
    private SpInfoService spInfoService;
    private Map<String, SpClient> spIdAndSpClientMap = Maps.newConcurrentMap();
    private MtStatusCallback mtStatusCallback;
    private AtomicInteger increment = new AtomicInteger();

    public boolean reloadConfig() {
        try {
            logger.info("Reloading configs...");
            this.reloadSpClientConfigs();
            this.reloadSpIdAndSp();
            logger.info("Complete reloaded configs...");
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return true;
    }

    private synchronized void reloadSpIdAndSp() {
        this.spIdAndSpClientMap.clear();
        for (SpClient spClient : this.spClients) {
            String spClass = spClient.spClass();
            if (Strings.isNullOrEmpty((String)spClass)) {
                logger.warn("No SpClass presents from SpClient: {}", (Object)spClient);
                continue;
            }
            Collection spInfoCollectionBySpClass = this.spInfoService.getSpInfoCollectionBySpClass(spClass);
            if (CollectionUtils.isEmpty((Collection)spInfoCollectionBySpClass)) {
                logger.warn("No sp config found with SpClient: {}, SpClass: {}", (Object)spClient, (Object)spClass);
                continue;
            }
            for (SpInfo spInfo : spInfoCollectionBySpClass) {
                String spId = spInfo.getSpId();
                if (Strings.isNullOrEmpty((String)spId)) {
                    logger.warn("No SpId found from SpInfo: {}", (Object)spInfo);
                    continue;
                }
                logger.info("Found SpId: {} and matches: {}", (Object)spId, (Object)spClient);
                this.spIdAndSpClientMap.put(spId, spClient);
            }
        }
    }

    private synchronized void reloadSpClientConfigs() {
        for (SpClient spClient : this.spClients) {
            HashMap<String, SpInfo> spIdSpInfoMap = new HashMap<String, SpInfo>();
            String spClass = spClient.spClass();
            if (Strings.isNullOrEmpty((String)spClass)) {
                logger.warn("No SpClass presents from SpClient: {}", (Object)spClient);
                continue;
            }
            Collection spInfoCollectionBySpClass = this.spInfoService.getSpInfoCollectionBySpClass(spClass);
            if (CollectionUtils.isEmpty((Collection)spInfoCollectionBySpClass)) {
                logger.warn("No sp config found with SpClient: {}, SpClass: {}", (Object)spClient, (Object)spClass);
                continue;
            }
            for (SpInfo spInfo : spInfoCollectionBySpClass) {
                String spId = spInfo.getSpId();
                spIdSpInfoMap.put(spId, spInfo);
            }
            logger.info("Setting config map: {} to sp client: {}", spIdSpInfoMap, (Object)spClient);
            spClient.setSpConfig(spIdSpInfoMap);
        }
    }

    @Override
    public SpClient getSpClient(String spId) {
        return this.spIdAndSpClientMap.get(spId);
    }

    @Override
    public void setStatusCallBack(MtStatusCallback mtStatusCallback) {
        this.mtStatusCallback = mtStatusCallback;
        logger.info("Setting mtStatusCallback: {} to sp clients: {}", (Object)mtStatusCallback, this.spClients);
        for (SpClient spClient : this.spClients) {
            spClient.setStatusCallback(mtStatusCallback);
        }
    }

    @Override
    public MtStatusCallback getStatusCallBack() {
        return this.mtStatusCallback;
    }

    @Override
    public void setSpClients(Collection<SpClient> spClients) {
        this.spClients = spClients;
    }

    @Override
    public Map.Entry<String, SpClient> getNextSpIdAndSpClientMap() {
        if (this.spIdAndSpClientMap.isEmpty()) {
            return null;
        }
        int len = this.spIdAndSpClientMap.size();
        int index = this.increment.getAndIncrement() % len;
        if (this.increment.get() >= 1000) {
            this.increment.set(0);
        }
        if (index < 0 || index >= len) {
            index = 0;
        }
        return (Map.Entry)this.spIdAndSpClientMap.entrySet().toArray()[index];
    }

    public void afterPropertiesSet() throws Exception {
        this.reloadConfig();
    }
}

