/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client;

import com.google.common.base.Optional;
import com.xunlei.channel.sms.client.AbstractMtSpClient;
import com.xunlei.channel.sms.entity.MtResult;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.entity.SpInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class BatchMtSpClient
extends AbstractMtSpClient {
    private static final Logger logger = LoggerFactory.getLogger(BatchMtSpClient.class);

    @Override
    public Map<SmsMessageRequest, List<MtResult>> sendSmsMessageAndReturnStatus(String spId, List<SmsMessageRequest> messages) {
        Optional<SpInfo> spInfoBySpId = this.getSpInfoBySpId(spId);
        if (!spInfoBySpId.isPresent()) {
            logger.error("Not found available for spId: {}", (Object)spId);
            return null;
        }
        SpInfo spInfo = (SpInfo)spInfoBySpId.get();
        HashMap<SmsMessageRequest, List<MtResult>> statusMap = new HashMap<SmsMessageRequest, List<MtResult>>();
        int maxBatchSize = this.maxBatchSize();
        if (maxBatchSize <= 0) {
            maxBatchSize = 1;
        }
        int index = 0;
        int size = messages.size();
        while (index < size) {
            List<SmsMessageRequest> smsMessageRequests;
            Map<SmsMessageRequest, List<MtResult>> batchStatusMap;
            int toIndex = index + maxBatchSize;
            if (toIndex > size) {
                toIndex = size;
            }
            if (!CollectionUtils.isEmpty(batchStatusMap = this.batchSendSmsMessageAndReturnStatus(spInfo, smsMessageRequests = messages.subList(index, toIndex)))) {
                statusMap.putAll(batchStatusMap);
            }
            index = toIndex;
        }
        return statusMap;
    }

    protected abstract int maxBatchSize();

    protected abstract Map<SmsMessageRequest, List<MtResult>> batchSendSmsMessageAndReturnStatus(SpInfo var1, List<SmsMessageRequest> var2);
}

