/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.xunlei.channel.sms.client.SpClient;
import com.xunlei.channel.sms.entity.MtResult;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.entity.SpInfo;
import com.xunlei.channel.sms.mt.MtStatusCallback;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMtSpClient
implements SpClient {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMtSpClient.class);
    protected MtStatusCallback callback;
    protected Map<String, SpInfo> spIdAndSpInfoMap;

    @Override
    public void setSpConfig(Map<String, SpInfo> spIdAndSpInfoMap) {
        this.spIdAndSpInfoMap = spIdAndSpInfoMap;
    }

    protected Optional<SpInfo> getSpInfoBySpId(String spId) {
        if (Strings.isNullOrEmpty((String)spId)) {
            return Optional.absent();
        }
        SpInfo spInfo = this.spIdAndSpInfoMap.get(spId);
        return Optional.of((Object)spInfo);
    }

    protected Optional<SpInfo> getSpInfo(SmsMessageRequest messageRequest) {
        String spId;
        if (messageRequest == null || (spId = messageRequest.getSpId()) == null) {
            return Optional.absent();
        }
        return this.getSpInfoBySpId(spId);
    }

    @Override
    public void setStatusCallback(MtStatusCallback callback) {
        this.callback = callback;
    }

    @Override
    public void sendSmsMessage(String spId, List<SmsMessageRequest> messages) {
        Map<SmsMessageRequest, List<MtResult>> messageAndStatusMap = this.sendSmsMessageAndReturnStatus(spId, messages);
        logger.info("Succeed sent messages, size: {}", (Object)messages.size());
        this.callback.statusUpdated(messageAndStatusMap);
    }

    public abstract Map<SmsMessageRequest, List<MtResult>> sendSmsMessageAndReturnStatus(String var1, List<SmsMessageRequest> var2);
}

