/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client;

import com.google.common.collect.Lists;
import com.xunlei.channel.sms.client.BatchMtSpClient;
import com.xunlei.channel.sms.client.ResultSizeIllegalException;
import com.xunlei.channel.sms.client.constant.SpBatchMode;
import com.xunlei.channel.sms.constants.SmsStatus;
import com.xunlei.channel.sms.entity.MtResult;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.entity.SpInfo;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractBatchModeSpClient
extends BatchMtSpClient {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBatchModeSpClient.class);

    protected abstract int maxSameContentBatchSize();

    protected abstract int maxDifferentContentBatchSize();

    protected abstract SpBatchMode[] supportBatchModes();

    protected abstract MtResult singleSend(SpInfo var1, SmsMessage var2) throws Exception;

    protected abstract List<MtResult> sendMultiplyContents(SpInfo var1, List<SmsMessage> var2) throws Exception;

    protected abstract List<MtResult> sendSameContentWithMobiles(SpInfo var1, List<SmsMessage> var2) throws Exception;

    @Override
    protected final int maxBatchSize() {
        int maxDifferentContentBatchSize = this.maxDifferentContentBatchSize();
        int maxSameContentBatchSize = this.maxSameContentBatchSize();
        if (maxDifferentContentBatchSize <= 0 && maxSameContentBatchSize <= 0) {
            return 1;
        }
        if (maxDifferentContentBatchSize >= 1) {
            return maxDifferentContentBatchSize;
        }
        return maxSameContentBatchSize;
    }

    @Override
    protected final Map<SmsMessageRequest, List<MtResult>> batchSendSmsMessageAndReturnStatus(SpInfo spInfo, List<SmsMessageRequest> messages) {
        if (this.isOnlySupportOne()) {
            return this.sendMessagesWhenOnlySupportOne(spInfo, messages);
        }
        if (messages.size() == 1) {
            return this.sendMessagesWhenOnlyOneMessage(spInfo, messages);
        }
        return this.sendMessageWhenMultiplyMessages(spInfo, messages);
    }

    private Map<SmsMessageRequest, List<MtResult>> sendMessageWhenMultiplyMessages(SpInfo spInfo, List<SmsMessageRequest> messageRequests) {
        boolean directBatchMode = this.isSupportAll() || this.isSupportAllBatchMode();
        int maxDifferentContentBatchSize = this.maxDifferentContentBatchSize();
        int maxSameContentBatchSize = this.maxSameContentBatchSize();
        if (directBatchMode) {
            if (maxDifferentContentBatchSize >= maxSameContentBatchSize) {
                return this.sendDifferentContent(spInfo, messageRequests);
            }
            ArrayList<SmsMessageRequest> sameContentRequests = new ArrayList<SmsMessageRequest>();
            ArrayList<SmsMessageRequest> differentContentRequests = new ArrayList<SmsMessageRequest>();
            for (SmsMessageRequest messageRequest : messageRequests) {
                if (messageRequest.isBatchSend()) {
                    sameContentRequests.add(messageRequest);
                    continue;
                }
                differentContentRequests.add(messageRequest);
            }
            HashMap<SmsMessageRequest, List<MtResult>> requestListMap = new HashMap<SmsMessageRequest, List<MtResult>>();
            Map<SmsMessageRequest, List<MtResult>> sameContentResult = this.sendSameContent(spInfo, sameContentRequests);
            Map<SmsMessageRequest, List<MtResult>> differentContentResult = this.sendDifferentContent(spInfo, differentContentRequests);
            if (!CollectionUtils.isEmpty(sameContentResult)) {
                requestListMap.putAll(sameContentResult);
            }
            if (!CollectionUtils.isEmpty(differentContentResult)) {
                requestListMap.putAll(differentContentResult);
            }
            logger.info("Sent use directBatchMode. messageRequests: {} and returns result: {}", messageRequests, requestListMap);
            return requestListMap;
        }
        if (this.supportSingleContentSend() && this.supportSameContentBatchSend()) {
            ArrayList<SmsMessageRequest> sameContentRequests = new ArrayList<SmsMessageRequest>();
            ArrayList<SmsMessageRequest> differentContentRequests = new ArrayList<SmsMessageRequest>();
            for (SmsMessageRequest messageRequest : messageRequests) {
                if (messageRequest.isBatchSend()) {
                    sameContentRequests.add(messageRequest);
                    continue;
                }
                differentContentRequests.add(messageRequest);
            }
            HashMap requestListMap = new HashMap();
            Map<SmsMessageRequest, List<MtResult>> sameContentResult = this.sendSameContent(spInfo, sameContentRequests);
            Map<SmsMessageRequest, List<MtResult>> differentContentResult = this.singleSend(spInfo, differentContentRequests);
            if (!CollectionUtils.isEmpty(sameContentResult)) {
                requestListMap.putAll(sameContentResult);
            }
            if (!CollectionUtils.isEmpty(differentContentResult)) {
                requestListMap.putAll(differentContentResult);
            }
            return requestListMap;
        }
        Map<SmsMessageRequest, List<MtResult>> smsMessageRequestListMap = this.sendDifferentContent(spInfo, messageRequests);
        logger.info("Sent use DIFFERENT_CONTENT. messageRequests: {} and returns result: {}", messageRequests, smsMessageRequestListMap);
        return smsMessageRequestListMap;
    }

    private Map<SmsMessageRequest, List<MtResult>> sendMessagesWhenOnlyOneMessage(SpInfo spInfo, List<SmsMessageRequest> messages) {
        SmsMessageRequest smsMessageRequest = messages.get(0);
        if (smsMessageRequest.getBatchSend() != null && smsMessageRequest.getBatchSend().booleanValue() && this.supportSameContentBatchSend()) {
            logger.info("Send message use same content method. spInfo: {}", (Object)spInfo);
            return this.sendSameContent(spInfo, messages);
        }
        if (this.supportDifferentContentBatchSend()) {
            logger.info("Send message use different content method. spInfo: {}", (Object)spInfo);
            return this.sendDifferentContent(spInfo, messages);
        }
        logger.info("Send message use single send method. spInfo: {}", (Object)spInfo);
        return this.singleSend(spInfo, messages);
    }

    private Map<SmsMessageRequest, List<MtResult>> sendMessagesWhenOnlySupportOne(SpInfo spInfo, List<SmsMessageRequest> messages) {
        if (this.supportDifferentContentBatchSend()) {
            Map<SmsMessageRequest, List<MtResult>> smsMessageRequestListMap = this.sendDifferentContent(spInfo, messages);
            logger.info("Send message use different content method. spInfo: {}", (Object)spInfo);
            return smsMessageRequestListMap;
        }
        if (this.supportSameContentBatchSend()) {
            Map<SmsMessageRequest, List<MtResult>> smsMessageRequestListMap = this.sendSameContent(spInfo, messages);
            logger.info("Send message use same content method. spInfo: {}", (Object)spInfo);
            return smsMessageRequestListMap;
        }
        Map<SmsMessageRequest, List<MtResult>> smsMessageRequestListMap = this.sendSameContent(spInfo, messages);
        logger.info("Send message use single send method. spInfo: {}", (Object)spInfo);
        return this.singleSend(spInfo, messages);
    }

    private Map<SmsMessageRequest, List<MtResult>> singleSend(SpInfo spInfo, List<SmsMessageRequest> messages) {
        HashMap<SmsMessageRequest, List<MtResult>> result = new HashMap<SmsMessageRequest, List<MtResult>>();
        for (SmsMessageRequest message : messages) {
            List smsMessages = message.getSmsMessages();
            ArrayList<MtResult> results = new ArrayList<MtResult>(smsMessages.size());
            for (SmsMessage smsMessage : smsMessages) {
                MtResult mtResult = null;
                try {
                    mtResult = this.singleSend(spInfo, smsMessage);
                }
                catch (Exception e) {
                    logger.error("Error when send message: " + messages + ". ERROR: " + e.getMessage(), (Throwable)e);
                    mtResult = MtResult.errorResult();
                }
                results.add(mtResult);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Single send message: {} and returns result: {}", (Object)smsMessage, (Object)mtResult);
            }
            result.put(message, results);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Sent message: {} and returns result: {}", messages, result);
        }
        return result;
    }

    private Map<SmsMessageRequest, List<MtResult>> sendSameContent(SpInfo spInfo, List<SmsMessageRequest> messages) {
        HashMap<SmsMessageRequest, List<MtResult>> result = new HashMap<SmsMessageRequest, List<MtResult>>();
        for (SmsMessageRequest message : messages) {
            List smsMessages = message.getSmsMessages();
            List lists = com.xunlei.channel.sms.util.CollectionUtils.splitBySize((List)smsMessages, (int)this.maxSameContentBatchSize());
            for (List subMessages : lists) {
                List<MtResult> results = null;
                try {
                    results = this.sendSameContentWithMobiles(spInfo, subMessages);
                }
                catch (Exception e) {
                    logger.error("Error when send message: " + messages + ". ERROR: " + e.getMessage(), (Throwable)e);
                    results = Arrays.asList(MtResult.errorResult());
                }
                result.put(message, results);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Batch send message: {} and returns results: {}", (Object)message, results);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Sent message: {} and returns result: {}", messages, result);
        }
        return result;
    }

    private Map<SmsMessageRequest, List<MtResult>> sendDifferentContent(SpInfo spInfo, List<SmsMessageRequest> messages) {
        HashMap<SmsMessageRequest, List<MtResult>> result = new HashMap<SmsMessageRequest, List<MtResult>>();
        ArrayList messageList = new ArrayList(this.maxDifferentContentBatchSize());
        for (SmsMessageRequest message : messages) {
            List smsMessages = message.getSmsMessages();
            messageList.addAll(smsMessages);
        }
        List lists = com.xunlei.channel.sms.util.CollectionUtils.splitBySize(messageList, (int)this.maxDifferentContentBatchSize());
        for (List subMessages : lists) {
            List<MtResult> results = null;
            try {
                results = this.sendMultiplyContents(spInfo, subMessages);
            }
            catch (Exception e) {
                logger.error("Error when send message: " + messages + ". ERROR: " + e.getMessage(), (Throwable)e);
                results = Arrays.asList(MtResult.errorResult());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Batch send message: {} and returns results: {}", (Object)subMessages, results);
            }
            SmsMessageRequest smsMessageRequest = this.buildMessageRequestByMessages(subMessages, results);
            result.put(smsMessageRequest, results);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Sent message: {} and returns result: {}", messages, result);
        }
        return result;
    }

    private SmsMessageRequest buildMessageRequestByMessages(List<SmsMessage> smsMessages, List<MtResult> results) {
        if (CollectionUtils.isEmpty(results)) {
            SmsMessageRequest smsMessageRequest = new SmsMessageRequest();
            smsMessageRequest.setSmsStatus(SmsStatus.FAIL);
            smsMessageRequest.setSmsMessages(smsMessages);
            return smsMessageRequest;
        }
        if (results.size() == 1) {
            MtResult mtResult = results.get(0);
            for (SmsMessage smsMessage : smsMessages) {
                this.setResultToMessage(mtResult, smsMessage);
            }
            SmsMessageRequest smsMessageRequest = new SmsMessageRequest();
            smsMessageRequest.setSmsMessages(smsMessages);
            return smsMessageRequest;
        }
        if (results.size() != smsMessages.size()) {
            throw new ResultSizeIllegalException("Result size not equals message size! Your implements batch send method must returns one result or same size of messages! message size: " + smsMessages.size() + ", but you returns: " + results.size());
        }
        HashMap<String, MtResult> uniqueNumberAndResultMap = new HashMap<String, MtResult>(results.size());
        for (MtResult result : results) {
            uniqueNumberAndResultMap.put(result.getUniqueNumber(), result);
        }
        for (SmsMessage smsMessage : smsMessages) {
            String uniqueNumber = smsMessage.getUniqueNumber();
            MtResult mtResult = (MtResult)uniqueNumberAndResultMap.get(uniqueNumber);
            this.setResultToMessage(mtResult, smsMessage);
        }
        SmsMessageRequest smsMessageRequest = new SmsMessageRequest();
        smsMessageRequest.setSmsMessages(smsMessages);
        return smsMessageRequest;
    }

    private List<SmsMessage> unpackMessageRequest(List<SmsMessageRequest> smsMessageRequests) {
        ArrayList<SmsMessage> messageList = new ArrayList<SmsMessage>(smsMessageRequests.size() * this.maxBatchSize());
        for (SmsMessageRequest smsMessageRequest : smsMessageRequests) {
            List smsMessages = smsMessageRequest.getSmsMessages();
            messageList.addAll(smsMessages);
        }
        return messageList;
    }

    private void setResultToMessage(MtResult result, SmsMessage message) {
        if (message == null || result == null) {
            logger.warn("Message or result is null when setResultToMessage... message: {} result: {}", (Object)message, (Object)result);
            return;
        }
        String spBatchId = result.getSpBatchId();
        SmsStatus smsStatus = result.getSmsStatus();
        if (StringUtils.hasText((String)spBatchId)) {
            String spMessageId = message.buildSpMessageId(spBatchId);
            message.setSpMessageId(spMessageId);
        }
        message.setSmsStatus(smsStatus.getStatus());
        message.setResult(result.getResult());
    }

    public boolean isSupportAll() {
        SpBatchMode[] spBatchModes = this.supportBatchModes();
        List<SpBatchMode> modeList = Arrays.asList(spBatchModes);
        for (SpBatchMode spBatchMode : SpBatchMode.values()) {
            if (modeList.contains((Object)spBatchMode)) continue;
            return false;
        }
        return true;
    }

    public boolean isSupportAllBatchMode() {
        SpBatchMode[] spBatchModes = this.supportBatchModes();
        List<SpBatchMode> modeList = Arrays.asList(spBatchModes);
        return modeList.contains((Object)SpBatchMode.SAME_CONTENT) && modeList.contains((Object)SpBatchMode.DIFFERENT_CONTENT);
    }

    private boolean isOnlySupportOne() {
        SpBatchMode[] spBatchModes = this.supportBatchModes();
        Assert.notEmpty((Object[])spBatchModes, (String)"batch mode must not be null!");
        return spBatchModes.length == 1;
    }

    private boolean supportSameContentBatchSend() {
        return this.supportMode(SpBatchMode.SAME_CONTENT);
    }

    private boolean supportDifferentContentBatchSend() {
        return this.supportMode(SpBatchMode.DIFFERENT_CONTENT);
    }

    private boolean supportSingleContentSend() {
        return this.supportMode(SpBatchMode.SINGLE_SEND);
    }

    private boolean supportMode(SpBatchMode mode) {
        ArrayList spBatchModes = Lists.newArrayList((Object[])this.supportBatchModes());
        return spBatchModes.contains((Object)mode);
    }
}

