/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.sequence.impl;

import com.xunlei.channel.sms.node.NodeNotAvailableException;
import com.xunlei.channel.sms.node.switcher.NodeSwitcher;
import com.xunlei.channel.sms.sequence.IdNodesEmptyException;
import com.xunlei.channel.sms.sequence.NodeSequenceIdGenerator;
import com.xunlei.channel.sms.sequence.SequenceIdGenerator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedSequenceIdGeneratorImpl
implements SequenceIdGenerator {
    private static final Logger logger = LoggerFactory.getLogger(DistributedSequenceIdGeneratorImpl.class);
    private List<NodeSequenceIdGenerator> nodes;
    private NodeSwitcher<NodeSequenceIdGenerator> nodeSwitcher;
    private int switchPolicy = 0;

    public DistributedSequenceIdGeneratorImpl(NodeSwitcher<NodeSequenceIdGenerator> nodeSwitcher, List<NodeSequenceIdGenerator> nodes) throws IdNodesEmptyException {
        this.nodeSwitcher = nodeSwitcher;
        if (nodes == null || nodes.isEmpty()) {
            throw new IdNodesEmptyException("Initializing SequenceIdGenerator error! Because nodes is empty!");
        }
        this.nodes = nodes;
        this.nodeSwitcher.setNodes(nodes);
    }

    @Override
    public long nextSequenceId() throws NodeNotAvailableException {
        long id = this.nextSequenceIdByMainNode();
        if (id != -1L) {
            for (NodeSequenceIdGenerator nodeSequenceIdGenerator : this.nodes) {
                nodeSequenceIdGenerator.updateNodeSequenceId(id);
            }
        } else {
            throw new NodeNotAvailableException(this.nodeSwitcher.getNode());
        }
        return id;
    }

    @Override
    public long getAndIncrementPullId() throws NodeNotAvailableException {
        long id = this.getAndIncrementPullIdByMainNode();
        if (id != -1L) {
            for (NodeSequenceIdGenerator node : this.nodes) {
                node.updateNodePullId(id);
            }
        } else {
            throw new NodeNotAvailableException(this.nodeSwitcher.getNode());
        }
        return id;
    }

    private long nextSequenceIdByMainNode() throws NodeNotAvailableException {
        NodeSequenceIdGenerator nodeSequenceIdGenerator = this.nodeSwitcher.getNode();
        try {
            long id = nodeSequenceIdGenerator.nextSequenceId();
            return id;
        }
        catch (NodeNotAvailableException e) {
            long id = this.switchAndNexSequenceId();
            return id;
        }
    }

    private long switchAndNexSequenceId() throws NodeNotAvailableException {
        boolean success = this.nodeSwitcher.switchNextNode(this.switchPolicy);
        if (success) {
            NodeSequenceIdGenerator nodeSequenceIdGenerator = this.nodeSwitcher.getNode();
            long id = nodeSequenceIdGenerator.nextSequenceId();
            return id;
        }
        return -1L;
    }

    private long getAndIncrementPullIdByMainNode() throws NodeNotAvailableException {
        try {
            NodeSequenceIdGenerator node = this.nodeSwitcher.getNode();
            long pullId = node.getAndIncrementPullId();
            return pullId;
        }
        catch (NodeNotAvailableException e) {
            long id = this.switchAndGetIncrementPullId();
            return id;
        }
    }

    private long switchAndGetIncrementPullId() throws NodeNotAvailableException {
        boolean success = this.nodeSwitcher.switchNextNode(this.switchPolicy);
        if (success) {
            NodeSequenceIdGenerator nodeSequenceIdGenerator = this.nodeSwitcher.getNode();
            long id = nodeSequenceIdGenerator.getAndIncrementPullId();
            return id;
        }
        return -1L;
    }
}

