/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.queue.node.impl;

import com.xunlei.channel.sms.node.switcher.NodeSwitcher;
import com.xunlei.channel.sms.queue.node.NodeQueue;
import com.xunlei.channel.sms.queue.node.impl.DistributedQueue;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class NodeQueueCleaner {
    private AtomicLong lastCleanSequenceId = new AtomicLong();
    private AtomicLong currentSequenceId = new AtomicLong();
    private long cleanSize = 1000L;
    private DistributedQueue distributedQueue;

    public NodeQueueCleaner(DistributedQueue distributedQueue) {
        this.distributedQueue = distributedQueue;
    }

    public boolean clean(long currentSequence) {
        this.currentSequenceId.set(currentSequence);
        if (this.currentSequenceId.get() - this.lastCleanSequenceId.get() < this.cleanSize) {
            return false;
        }
        this.lastCleanSequenceId.set(currentSequence);
        ArrayList nodes = this.distributedQueue.getNodes();
        NodeSwitcher nodeSwitcher = this.distributedQueue.getNodeSwitcher();
        NodeQueue current = nodeSwitcher.getNode();
        for (NodeQueue node : nodes) {
            if (current.equals(node)) continue;
            node.skipToId(currentSequence);
        }
        return true;
    }

    public long getCleanSize() {
        return this.cleanSize;
    }

    public void setCleanSize(long cleanSize) {
        this.cleanSize = cleanSize;
    }
}

