/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.serialize.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xunlei.channel.sms.serialize.AbstractQueueDataConverter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonQueueDataConverter<E>
extends AbstractQueueDataConverter<E, String> {
    private static final Logger logger = LoggerFactory.getLogger(JacksonQueueDataConverter.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final ThreadLocal<ObjectMapper> MAPPER_THREAD_LOCAL = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDateFormat((DateFormat)new SimpleDateFormat(JacksonQueueDataConverter.DATE_FORMAT));
            return mapper;
        }
    };

    public JacksonQueueDataConverter(Class<E> type) {
        super(type);
        logger.info("Inited jackson queue data converter with entityType: {}", (Object)this.entityType);
    }

    @Override
    public String serialize(E entity) throws Exception {
        ObjectMapper mapper = MAPPER_THREAD_LOCAL.get();
        String json = mapper.writeValueAsString(entity);
        if (logger.isDebugEnabled()) {
            logger.debug("Serialize entity: {} to string: {}", entity, (Object)json);
        }
        return json;
    }

    @Override
    public E deserialize(String rawData) throws Exception {
        ObjectMapper mapper = MAPPER_THREAD_LOCAL.get();
        Object entity = mapper.readValue(rawData, this.entityType);
        if (logger.isDebugEnabled()) {
            logger.debug("Deserialize string: {} to entity: {}", (Object)rawData, entity);
        }
        return (E)entity;
    }
}

