/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.queue.node.impl;

import com.xunlei.channel.sms.node.NodeNotAvailableException;
import com.xunlei.channel.sms.node.switcher.NodeSwitcher;
import com.xunlei.channel.sms.queue.Queue;
import com.xunlei.channel.sms.queue.QueueElement;
import com.xunlei.channel.sms.queue.node.NodeQueue;
import com.xunlei.channel.sms.queue.node.impl.NodeQueueCleaner;
import com.xunlei.channel.sms.sequence.SequenceIdGenerator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedQueue<T>
implements Queue<T> {
    private static final Logger logger = LoggerFactory.getLogger(DistributedQueue.class);
    private SequenceIdGenerator sequenceIdGenerator;
    private NodeSwitcher<NodeQueue<T>> nodeSwitcher;
    private ArrayList<NodeQueue<T>> nodes = new ArrayList();
    private int switchPolicy = 0;
    private NodeQueueCleaner nodeQueueCleaner = new NodeQueueCleaner(this);
    private String queueId;

    public DistributedQueue(SequenceIdGenerator sequenceIdGenerator, NodeSwitcher<NodeQueue<T>> nodeSwitcher, ArrayList<NodeQueue<T>> nodes, int switchPolicy, String queueId) {
        this.sequenceIdGenerator = sequenceIdGenerator;
        this.nodeSwitcher = nodeSwitcher;
        this.switchPolicy = switchPolicy;
        this.queueId = queueId;
        this.setNodes(nodes);
    }

    public DistributedQueue() {
    }

    @Override
    public boolean push(QueueElement<T> t) {
        long id = 0L;
        try {
            id = this.sequenceIdGenerator.nextSequenceId();
        }
        catch (NodeNotAvailableException e) {
            logger.error("Caught exception when get sequence id! message: " + e.getMessage(), (Throwable)e);
            return false;
        }
        t.setSequenceId(id);
        boolean result = false;
        for (NodeQueue<T> node : this.nodes) {
            try {
                boolean nodeResult = node.push(t);
                result |= nodeResult;
            }
            catch (Exception e) {
                result |= false;
                logger.error("Push data to node: " + node + " queue: " + node.getQueueId(), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public boolean asynchronousPush(QueueElement<T> t) {
        throw new RuntimeException("Not support asynchronousPush!");
    }

    @Override
    public List<QueueElement<T>> pull() {
        return this.pull(true);
    }

    @Override
    public List<QueueElement<T>> pull(boolean blocking) {
        List<QueueElement<T>> element;
        long id;
        block5: {
            id = 0L;
            try {
                id = this.sequenceIdGenerator.getAndIncrementPullId();
            }
            catch (NodeNotAvailableException e) {
                logger.error("Caught exception when get pull id! message: " + e.getMessage(), (Throwable)e);
                return null;
            }
            NodeQueue<T> node = this.nodeSwitcher.getNode();
            boolean isBlocking = blocking & node.supportBlockingPull();
            try {
                element = node.pull(isBlocking);
            }
            catch (NodeNotAvailableException e) {
                logger.error("Pulling data error from node: " + node + " queue id: " + this.queueId + " with message: " + e.getMessage(), (Throwable)e);
                element = this.switchAndPull(id, isBlocking);
                if (element != null) break block5;
                logger.error("Pulled data is null when switched node!");
            }
        }
        boolean clean = this.nodeQueueCleaner.clean(id);
        if (clean) {
            logger.debug("Cleaned node queue's data to sequence: {}", (Object)id);
        }
        return element;
    }

    private List<QueueElement<T>> switchAndPull(long id, boolean blocking) {
        boolean success = this.nodeSwitcher.switchNextNode(this.switchPolicy);
        if (success) {
            NodeQueue<T> node = this.nodeSwitcher.getNode();
            try {
                boolean b = node.skipToId(id);
                if (!b) {
                    logger.error("Skip to id error! node: {} id: {}", node, (Object)id);
                }
                List<QueueElement<T>> element = node.pull(blocking);
                return element;
            }
            catch (NodeNotAvailableException e) {
                logger.error("Failed to switch node and pull data! It must be node's logic is error!", (Throwable)e);
                return null;
            }
        }
        logger.error("Failed to switch node!");
        return null;
    }

    @Override
    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    @Override
    public String getQueueId() {
        return this.queueId;
    }

    public void addNode(NodeQueue<T> nodeQueue) {
        if (nodeQueue == null) {
            logger.error("Adding to a new queue node error! The node to be add is null!");
            return;
        }
        this.nodes.add(nodeQueue);
        this.setNodesToSwitcher();
    }

    public ArrayList<NodeQueue<T>> getNodes() {
        return this.nodes;
    }

    public void setNodes(ArrayList<NodeQueue<T>> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            logger.error("Nodes is empty when setting nodes!");
            return;
        }
        this.nodes = nodes;
        this.setNodesToSwitcher();
    }

    public SequenceIdGenerator getSequenceIdGenerator() {
        return this.sequenceIdGenerator;
    }

    public void setSequenceIdGenerator(SequenceIdGenerator sequenceIdGenerator) {
        this.sequenceIdGenerator = sequenceIdGenerator;
    }

    public NodeSwitcher<NodeQueue<T>> getNodeSwitcher() {
        return this.nodeSwitcher;
    }

    public void setNodeSwitcher(NodeSwitcher<NodeQueue<T>> nodeSwitcher) {
        this.nodeSwitcher = nodeSwitcher;
    }

    public int getSwitchPolicy() {
        return this.switchPolicy;
    }

    public void setSwitchPolicy(int switchPolicy) {
        this.switchPolicy = switchPolicy;
    }

    private void setNodesToSwitcher() {
        if (this.nodeSwitcher != null) {
            this.nodeSwitcher.setNodes(this.nodes);
        }
    }
}

