/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.queue.kafka;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.clients.producer.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class KafkaQueueSubmitter {
    private static final Logger logger = LoggerFactory.getLogger(KafkaQueueSubmitter.class);
    private static Map<Producer, KafkaQueueSubmitter> producerKafkaQueueSubmitterMap = new ConcurrentHashMap<Producer, KafkaQueueSubmitter>();
    private long timeoutMills = 1000L;
    private long deadlineTime;
    private Producer producer;

    public static void watchProducer(Producer producer, long timeoutMills) {
        new KafkaQueueSubmitter(producer, timeoutMills);
    }

    private KafkaQueueSubmitter(Producer producer, long timeoutMills) {
        Assert.isTrue((timeoutMills > 0L ? 1 : 0) != 0, (String)"timeoutMills must greater than zero!");
        Assert.notNull((Object)producer, (String)"Kafka producer could'nt be null!");
        this.producer = producer;
        this.timeoutMills = timeoutMills;
        this.deadlineTime = System.currentTimeMillis() + timeoutMills;
        producerKafkaQueueSubmitterMap.put(producer, this);
    }

    public static void submitted(Producer producer) {
        KafkaQueueSubmitter kafkaQueueSubmitter = producerKafkaQueueSubmitterMap.get(producer);
        if (kafkaQueueSubmitter == null) {
            logger.error("Error not found submitter, you must wathc producer first!");
            return;
        }
        kafkaQueueSubmitter.submitted();
    }

    public void submitted() {
        if (System.currentTimeMillis() >= this.deadlineTime) {
            try {
                this.producer.flush();
            }
            catch (Exception e) {
                logger.error("Error when flush kafka producer! Message: " + e.getMessage(), (Throwable)e);
            }
            this.deadlineTime = System.currentTimeMillis() + this.timeoutMills;
            logger.info("Flush producer and reset deadlineTime from: {} to: {}", (Object)(this.deadlineTime - this.timeoutMills), (Object)this.deadlineTime);
        }
    }
}

