/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.queue.jdk;

import com.xunlei.channel.sms.queue.Queue;
import com.xunlei.channel.sms.queue.QueueElement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class BlockingQueue<T>
implements Queue<T> {
    private static final Logger logger = LoggerFactory.getLogger(BlockingQueue.class);
    private LinkedBlockingQueue<QueueElement<T>> linkedBlockingQueue = new LinkedBlockingQueue();

    @Override
    public boolean push(QueueElement<T> t) {
        try {
            this.linkedBlockingQueue.put(t);
        }
        catch (InterruptedException e) {
            logger.error("Error when push to queue, message: " + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean asynchronousPush(QueueElement<T> t) {
        return this.push(t);
    }

    @Override
    public void setQueueId(String queueId) {
    }

    @Override
    public String getQueueId() {
        return null;
    }

    @Override
    public List<QueueElement<T>> pull() {
        ArrayList<QueueElement<T>> elements = new ArrayList<QueueElement<T>>();
        try {
            for (int i = 0; i < 4000; ++i) {
                QueueElement<T> poll = this.linkedBlockingQueue.poll(1000L, TimeUnit.MILLISECONDS);
                elements.add(poll);
            }
        }
        catch (InterruptedException e) {
            logger.error("Error when push to queue, message: " + e.getMessage(), (Throwable)e);
        }
        return elements;
    }

    @Override
    public List<QueueElement<T>> pull(boolean blocking) {
        List<QueueElement<T>> queueElements = this.pull();
        while (blocking && CollectionUtils.isEmpty(queueElements)) {
            if (logger.isDebugEnabled()) {
                logger.debug("No record return, so retry to pull.");
            }
            queueElements = this.pull();
        }
        return queueElements;
    }
}

