/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.node.switcher.impl;

import com.xunlei.channel.sms.node.Node;
import com.xunlei.channel.sms.node.switcher.NodeSwitcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeSwitcherImpl<T extends Node>
implements NodeSwitcher<T>,
Comparator<T> {
    private static final Logger logger = LoggerFactory.getLogger(NodeSwitcherImpl.class);
    private AtomicReference<T> currentNode = new AtomicReference();
    private List<T> nodes = new ArrayList<T>();
    private final Lock writeLock = new ReentrantLock();
    private AtomicBoolean switching = new AtomicBoolean(false);

    private void sortNodes() {
        Collections.sort(this.nodes, this);
    }

    @Override
    public int compare(T o1, T o2) {
        return o1.priority() - o2.priority();
    }

    @Override
    public void setNodes(List<T> nodes) {
        this.writeLock.lock();
        try {
            if (nodes == null) {
                return;
            }
            this.nodes = nodes;
            this.sortNodes();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public T getNode() {
        Node useful;
        Node node;
        do {
            if ((node = (Node)this.currentNode.get()) != null) {
                return (T)node;
            }
            if (this.nodes == null || this.nodes.isEmpty()) {
                logger.error("Pulling data error! Nodes is empty!");
                return null;
            }
            boolean b = this.switchNextNode(0);
        } while (!this.currentNode.compareAndSet(node, useful = (Node)this.currentNode.get()));
        return (T)useful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean switchNextNode(int policy) {
        if (this.nodes.isEmpty()) {
            return false;
        }
        if (this.switching.get()) {
            logger.warn("NodeSwitcher is switching to next node! so wait for done.");
            Node preNode = (Node)this.currentNode.get();
            while (this.switching.get()) {
            }
            if (logger.isDebugEnabled()) {
                logger.debug("The switch thread switched node success, prevent node is: {} and switch to node: {}", (Object)preNode, this.currentNode);
            }
            preNode = null;
            return true;
        }
        Node preNode = (Node)this.currentNode.get();
        this.writeLock.lock();
        try {
            if (!this.checkNodes()) {
                boolean bl = false;
                return bl;
            }
            if (preNode != this.currentNode.get()) {
                logger.info("Node has switched, so return... prevent node: {} current node: {}", (Object)preNode, this.currentNode.get());
                boolean bl = true;
                return bl;
            }
            if (!this.switching.compareAndSet(false, true)) {
                logger.error("lock switch error! please check lock logic!");
            }
            boolean switchSuccess = this.switchNext(policy);
            if (!this.switching.compareAndSet(true, false)) {
                logger.error("lock switch error! please check lock logic!");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Switch node success, prevent node is: {} and switch to node: {}", (Object)preNode, this.currentNode.get());
            }
            boolean bl = switchSuccess;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean checkNodes() {
        if (logger.isDebugEnabled()) {
            logger.debug("Nodes: {}", this.nodes);
        }
        if (this.nodes == null || this.nodes.isEmpty()) {
            logger.error("Switch node error because nodes is empty!");
            return false;
        }
        if (this.nodes.size() <= 1) {
            logger.warn("Node size is less than 2, so don't need to switch!");
            return false;
        }
        return true;
    }

    private boolean switchNext(int policy) {
        if (this.currentNode.get() == null) {
            this.currentNode.set(this.nodes.get(0));
            return true;
        }
        if (policy == 1) {
            return this.switchNextNodeByCycle();
        }
        if (policy == 0) {
            return this.switchNextNodeByPriority();
        }
        return this.switchNextNodeByPriority();
    }

    private boolean switchNextNodeByPriority() {
        for (Node node : this.nodes) {
            if (node.equals(this.currentNode.get()) || !node.available()) continue;
            this.currentNode.set(node);
            return true;
        }
        return true;
    }

    private boolean switchNextNodeByCycle() {
        boolean start = false;
        boolean ended = false;
        Iterator<T> iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!iterator.hasNext()) {
                if (!ended) {
                    iterator = this.nodes.iterator();
                    ended = true;
                } else {
                    return false;
                }
            }
            if (node.equals(this.currentNode.get())) {
                if (start) {
                    return false;
                }
                start = true;
                continue;
            }
            if (!start) continue;
            if (!node.available()) {
                return false;
            }
            this.currentNode.set(node);
            return true;
        }
        return false;
    }
}

