/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.controller;

import com.xunlei.channel.sms.entity.MobileVerifyRequest;
import com.xunlei.channel.sms.entity.OldResultCode;
import com.xunlei.channel.sms.entity.ReturnResult;
import com.xunlei.channel.sms.support.verifycode.SmsMessageVerifyCodeSupporter;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@ResponseBody
public class SmsVerifyController {
    private static final Logger logger = LoggerFactory.getLogger(SmsVerifyController.class);
    @Autowired
    private SmsMessageVerifyCodeSupporter verifyCodeSupporter;

    @RequestMapping(value={"/verify"})
    public ReturnResult verify(@Valid MobileVerifyRequest verify, BindingResult bindingResult, HttpServletRequest request) {
        ReturnResult verifyResult = this.verifyCodeSupporter.verify(verify);
        if (logger.isDebugEnabled()) {
            logger.debug("Verify result: {}, request is: {}", (Object)verifyResult, (Object)verify);
        }
        return verifyResult;
    }

    @RequestMapping(value={"/validate"}, consumes={"application/xml"})
    public OldResultCode validate(MobileVerifyRequest verify) {
        return new OldResultCode();
    }
}

