/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.controller;

import com.xunlei.channel.sms.cache.CacheException;
import com.xunlei.channel.sms.cache.CacheService;
import com.xunlei.channel.sms.cache.CacheServiceProvider;
import com.xunlei.channel.sms.cache.vo.Cache;
import com.xunlei.channel.sms.entity.MachineInfo;
import com.xunlei.channel.sms.util.NetWorkUtils;
import com.xunlei.channel.sms.util.SequenceGenerator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/machineInfo"})
public class SmsMachineInfoController
implements InitializingBean {
    public static final String CACHE_GROUP_MACHINE_INFO = "MACHINE_INFO";
    private static final Logger logger = LoggerFactory.getLogger(SmsMachineInfoController.class);
    @Autowired
    private CacheServiceProvider cacheServiceProvider;

    @GetMapping(value={""})
    public Collection<MachineInfo> getMachineInfo() {
        Collection<MachineInfo> machineInfoCollection = this.getMachineInfoCollection();
        if (logger.isDebugEnabled()) {
            logger.debug("Getting machineInfo collection: {}", machineInfoCollection);
        }
        return machineInfoCollection;
    }

    @GetMapping(value={"/machineNumber/{machineNumber}"})
    public MachineInfo getMachineInfoByMachineNumber(@PathVariable String machineNumber) {
        MachineInfo machineInfo = this.findMachineInfoByNumber(machineNumber);
        logger.info("Found machineInfo: {} by machineNumber: {}", (Object)machineInfo, (Object)machineNumber);
        return machineInfo;
    }

    @GetMapping(value={"/uniqueNumber/{uniqueNumber}"})
    public MachineInfo getMachineInfoByUniqueNumber(@PathVariable String uniqueNumber) {
        String machineNumber = SequenceGenerator.getMachineNumberBySequence((String)uniqueNumber);
        MachineInfo machineInfo = this.findMachineInfoByNumber(machineNumber);
        logger.info("Found machineInfo: {} by uniqueNumber: {}", (Object)machineInfo, (Object)uniqueNumber);
        return machineInfo;
    }

    public void afterPropertiesSet() throws Exception {
        this.initMachineInfo();
    }

    private MachineInfo findMachineInfoByNumber(String machineNumber) {
        CacheService cacheService = this.cacheServiceProvider.getCacheService();
        try {
            String cacheValue = cacheService.getCacheValue(CACHE_GROUP_MACHINE_INFO, machineNumber);
            MachineInfo machineInfo = MachineInfo.fromJson((String)cacheValue);
            return machineInfo;
        }
        catch (Exception e) {
            logger.error("Error when getting machine info by machineNumber: " + machineNumber + ". Message: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Collection<MachineInfo> getMachineInfoCollection() {
        CacheService cacheService = this.cacheServiceProvider.getCacheService();
        try {
            Collection caches = cacheService.getCachesByGroup(CACHE_GROUP_MACHINE_INFO);
            ArrayList<MachineInfo> machineInfos = new ArrayList<MachineInfo>(caches.size());
            for (Cache cache : caches) {
                String cacheValue = cache.getCacheValue();
                MachineInfo machineInfo = MachineInfo.fromJson((String)cacheValue);
                machineInfos.add(machineInfo);
            }
            return machineInfos;
        }
        catch (Exception e) {
            logger.error("Error when getting cache by group: MACHINE_INFO. Error message: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void initMachineInfo() {
        String widthMachineNumber = null;
        try {
            widthMachineNumber = NetWorkUtils.getWidthMachineNumber();
            String hostName = NetWorkUtils.getHostName();
            String hostIp = NetWorkUtils.getHostIp((InetAddress)NetWorkUtils.getInetAddress());
            MachineInfo machineInfo = new MachineInfo();
            machineInfo.setMachineNumber(widthMachineNumber);
            machineInfo.setHostName(hostName);
            machineInfo.setIp(hostIp);
            this.addMachineInfo(machineInfo);
        }
        catch (UnknownHostException e) {
            logger.error("Error when getting machine info. Message: " + e.getMessage(), (Throwable)e);
        }
    }

    private void addMachineInfo(MachineInfo machineInfo) {
        Cache cache = new Cache();
        cache.setCacheGroup(CACHE_GROUP_MACHINE_INFO);
        cache.setCacheName(machineInfo.getMachineNumber());
        cache.setCacheValue(machineInfo.toJson());
        CacheService cacheService = this.cacheServiceProvider.getCacheService();
        try {
            cacheService.setCache(cache);
        }
        catch (CacheException e) {
            logger.error("Error when settings cache: " + cache + ". Error message: " + e.getMessage(), (Throwable)e);
        }
    }
}

