/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.controller;

import com.xunlei.channel.sms.core.SmsMessageHandler;
import com.xunlei.channel.sms.entity.OldResultCode;
import com.xunlei.channel.sms.entity.OldSmsMessageRequest;
import com.xunlei.channel.sms.entity.ReturnResult;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.util.ip.RemoteIpUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SmsController {
    public static final Logger logger = LoggerFactory.getLogger(SmsController.class);
    @Qualifier(value="messageHandler")
    @Autowired
    private SmsMessageHandler messageHandler;
    @Qualifier(value="concurrentMessageHandler")
    @Autowired
    private SmsMessageHandler concurrentMessageHandler;
    @Autowired
    private HttpServletRequest httpServletRequest;

    @RequestMapping(value={"/sms"}, consumes={"application/xml"}, produces={"application/xml"})
    @ResponseBody
    public ReturnResult sendSmsByXml(@Valid SmsMessageRequest message, BindingResult bindingResult) {
        return this.sendSms(message, bindingResult);
    }

    @RequestMapping(value={"/sms"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public ReturnResult sendSmsByJson(@Valid SmsMessageRequest message, BindingResult bindingResult) {
        return this.sendSms(message, bindingResult);
    }

    @RequestMapping(value={"/sms"})
    @ResponseBody
    public ReturnResult sendSms(@Valid SmsMessageRequest message, BindingResult bindingResult) {
        String ipFromRequest = RemoteIpUtils.getIpFromRequest((HttpServletRequest)this.httpServletRequest);
        message.setRequestIp(ipFromRequest);
        if (logger.isDebugEnabled()) {
            logger.debug("Get remote ip: {}", (Object)ipFromRequest);
        }
        return this.messageHandler.handleRequest(message, true);
    }

    @RequestMapping(value={"/concurrent-sms"}, consumes={"application/xml"}, produces={"application/xml"})
    @ResponseBody
    public ReturnResult sendConcurrentSmsByXml(@Valid SmsMessageRequest message, BindingResult bindingResult) {
        return this.sendConcurrentSms(message, bindingResult);
    }

    @RequestMapping(value={"/concurrent-sms"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public ReturnResult sendConcurrentSmsByJson(@Valid SmsMessageRequest message, BindingResult bindingResult) {
        return this.sendConcurrentSms(message, bindingResult);
    }

    @RequestMapping(value={"/concurrent-sms"})
    @ResponseBody
    public ReturnResult sendConcurrentSms(@Valid SmsMessageRequest message, BindingResult bindingResult) {
        String ipFromRequest = RemoteIpUtils.getIpFromRequest((HttpServletRequest)this.httpServletRequest);
        message.setRequestIp(ipFromRequest);
        if (logger.isDebugEnabled()) {
            logger.debug("Get remote ip: {}", (Object)ipFromRequest);
        }
        return this.concurrentMessageHandler.handleRequest(message, true);
    }

    @RequestMapping(value={"/sendsms"}, produces={"application/xml"})
    @ResponseBody
    public OldResultCode sendSmsByOldVersion(HttpServletRequest request, OldSmsMessageRequest message) {
        return null;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String test = URLEncoder.encode("\u6d4b\u8bd5", "UTF-8");
        System.out.println(test);
    }
}

