/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.controller;

import com.xunlei.channel.sms.config.ConfigReloadable;
import com.xunlei.channel.sms.entity.ReturnResult;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admin/config"})
@ResponseBody
public class ConfigController {
    private static final Logger logger = LoggerFactory.getLogger(ConfigController.class);
    @Autowired(required=false)
    private Collection<ConfigReloadable> configReloadables;

    @RequestMapping(value={"/reload"})
    public ReturnResult reloadConfigs() {
        if (this.configReloadables == null) {
            return ReturnResult.SUCCESS;
        }
        for (ConfigReloadable configReloadable : this.configReloadables) {
            try {
                logger.info("Reload configs in: {}", (Object)configReloadable);
                configReloadable.reloadConfig();
            }
            catch (Exception e) {
                logger.error("Error when reload config: " + configReloadable + " message: " + e.getMessage(), (Throwable)e);
            }
        }
        return ReturnResult.SUCCESS;
    }
}

