/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.filter;

import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;

public class HttpRequestDebugger
implements WebRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestDebugger.class);

    public void preHandle(WebRequest webRequest) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("WebRequest: {}", (Object)webRequest);
            HttpRequestDebugger.logHeader(webRequest);
            HttpRequestDebugger.logHttp(webRequest);
        }
    }

    private static void logHttp(WebRequest webRequest) {
        logger.debug("ContextPath: {}", (Object)webRequest.getContextPath());
        logger.debug("Parameters: {}", (Object)webRequest.getParameterMap());
    }

    private static void logHeader(WebRequest webRequest) {
        Iterator headerNames = webRequest.getHeaderNames();
        while (headerNames.hasNext()) {
            String headerName = (String)headerNames.next();
            Object[] headerValues = webRequest.getHeaderValues(headerName);
            logger.debug("HeaderName: {}, HeaderValues: {}", (Object)headerName, (Object)Arrays.toString(headerValues));
        }
    }

    public void postHandle(WebRequest webRequest, ModelMap modelMap) throws Exception {
    }

    public void afterCompletion(WebRequest webRequest, Exception e) throws Exception {
    }
}

