/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.exception;

import com.xunlei.channel.sms.entity.ReturnResult;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.springframework.web.servlet.view.xml.MappingJackson2XmlView;

public class SmsGatewayExceptionHandler
extends AbstractHandlerExceptionResolver {
    private static final Logger logger = LoggerFactory.getLogger(SmsGatewayExceptionHandler.class);
    private static final String ACCEPT = "Accept";
    private static final String EXCEPTION_JSP_PATH = "exception";

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        String accept = request.getHeader(ACCEPT);
        ReturnResult result = ReturnResult.SYSTEM_ERROR;
        if (logger.isDebugEnabled()) {
            logger.debug("get Accept:{}", (Object)accept);
        }
        logger.error("Exception occurs from " + handler, (Throwable)ex);
        if ("text/html".equals(accept) || "application/xhtml+xml".equals(accept)) {
            ModelAndView modelAndView = new ModelAndView(EXCEPTION_JSP_PATH);
            return modelAndView;
        }
        ModelAndView modelAndView = new ModelAndView();
        if ("application/json".equals(accept)) {
            modelAndView.setView((View)new MappingJackson2JsonView());
        } else {
            modelAndView.setView((View)new MappingJackson2XmlView());
        }
        modelAndView.addObject((Object)result);
        return modelAndView;
    }
}

