/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.controller;

import com.xunlei.channel.sms.chain.sign.SmsMessageCheckSignInterceptor;
import com.xunlei.channel.sms.entity.ReturnResult;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.entity.SmsResponse;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import com.xunlei.channel.sms.risk.threathunter.ThreatHunterService;
import com.xunlei.channel.sms.risk.threathunter.entity.MobileRiskReturnResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/risk"})
public class SmsRiskController {
    private static final Logger logger = LoggerFactory.getLogger(SmsRiskController.class);
    @Autowired
    private ThreatHunterService threatHunterService;
    @Autowired
    private SmsMessageCheckSignInterceptor checkSignInterceptor;
    public static final String MOBILES_PATTERN = "1[0-9]{10}(,1[0-9]{10})*";
    public static final Pattern PATTERN = Pattern.compile("1[0-9]{10}(,1[0-9]{10})*");

    @PostMapping(value={"/mobile"})
    @ResponseBody
    public ReturnResult queryMobileRisk(SmsMessageRequest messageRequest) {
        InterceptResult intercept = this.checkSignInterceptor.intercept(messageRequest);
        if (!intercept.isSuccess()) {
            return intercept;
        }
        String mobilesString = messageRequest.getMobiles();
        if (StringUtils.isEmpty((Object)mobilesString)) {
            return new InterceptResult(Integer.valueOf(100), "parameter mobiles could'nt be null!", "\u53c2\u6570\uff1amobiles\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        boolean match = SmsRiskController.mobileLegitimate(mobilesString);
        if (!match) {
            return new InterceptResult(Integer.valueOf(100), "illegal parameter mobiles!", "\u53c2\u6570\uff1amobiles\u683c\u5f0f\u9519\u8bef\uff01\u6b63\u786e\u7684\u683c\u5f0f\u662f\uff1a 13888888888,13811111111,13811112222");
        }
        Object[] mobiles = mobilesString.split(",");
        Collection results = this.threatHunterService.requestAndReturnRiskResult((String[])mobiles);
        SmsResponse smsResponse = MobileRiskReturnResult.newResult((Object)results);
        if (logger.isInfoEnabled()) {
            logger.info("Returns risk result: {} by mobiles: {}", (Object)smsResponse, (Object)Arrays.toString(mobiles));
        }
        return smsResponse;
    }

    public static boolean mobileLegitimate(String mobile) {
        Matcher matcher = PATTERN.matcher(mobile);
        return matcher.matches();
    }
}

