/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.interceptor.manager.impl;

import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.interceptor.SmsMessageInterceptor;
import com.xunlei.channel.sms.interceptor.manager.SmsMessageInterceptorManager;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class SmsMessageInterceptorManagerImpl
implements SmsMessageInterceptorManager,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(SmsMessageInterceptorManagerImpl.class);
    @Autowired
    private List<SmsMessageInterceptor> interceptors;
    private AtomicBoolean writing = new AtomicBoolean();

    @Override
    public InterceptResult intercept(SmsMessageRequest message) {
        this.checkLock();
        for (SmsMessageInterceptor interceptor : this.interceptors) {
            try {
                InterceptResult interceptResult = interceptor.intercept(message);
                if (interceptResult == null) {
                    logger.info("No result return by interceptor: {}. request: {}, result: {}", new Object[]{interceptor, message, interceptor});
                    return InterceptResult.SUCCESS;
                }
                if (!interceptResult.isSuccess()) {
                    logger.info("Intercepted a pay request by interceptor: {}. request: {}, result: {}", new Object[]{interceptor, message, interceptResult});
                    return interceptResult;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Passed a pay request by interceptor: {}. request: {}, result: {}", new Object[]{interceptor, message, interceptResult});
            }
            catch (Exception e) {
                logger.error("Error when intercept message: " + message + " with interceptor: " + interceptor + ". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return InterceptResult.SUCCESS;
    }

    @Override
    public List<SmsMessageInterceptor> getSortedInterceptors() {
        return this.interceptors;
    }

    private void checkLock() {
        while (this.writing.get()) {
            logger.debug("Try to intercept, but interceptor is modify, so wait for done.");
        }
    }

    public void addInterceptor(SmsMessageInterceptor messageInterceptor) {
        block9: {
            while (!this.writing.compareAndSet(false, true)) {
                logger.warn("Try to write, but another is locking, so wait for another thread done...");
            }
            try {
                if (this.interceptors == null) {
                    this.interceptors = new ArrayList<SmsMessageInterceptor>();
                }
                this.interceptors.add(messageInterceptor);
                if (logger.isDebugEnabled()) {
                    logger.debug("Added interceptor: {}", (Object)messageInterceptor);
                }
                this.sortInterceptors();
                if (!logger.isDebugEnabled()) break block9;
                logger.debug("Added interceptor: {} sorted interceptors: {}", (Object)messageInterceptor, this.interceptors);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
            finally {
                while (!this.writing.compareAndSet(true, false)) {
                    logger.warn("Try to unlock, but another is locking, so wait for another thread done...");
                }
            }
        }
    }

    private void sortInterceptors() {
        Collections.sort(this.interceptors, new Comparator<SmsMessageInterceptor>(){

            @Override
            public int compare(SmsMessageInterceptor o1, SmsMessageInterceptor o2) {
                return o1.compareTo(o2);
            }
        });
    }

    public List<SmsMessageInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<SmsMessageInterceptor> interceptors) {
        if (interceptors == null) {
            return;
        }
        this.interceptors = interceptors;
        this.sortInterceptors();
    }

    public void afterPropertiesSet() throws Exception {
        this.sortInterceptors();
    }
}

