/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.health.exception;

import com.xunlei.channel.sms.cache.CacheException;
import com.xunlei.channel.sms.health.SmsHealthIndicator;
import com.xunlei.channel.sms.health.SmsHealthInfo;
import com.xunlei.channel.sms.health.exception.ExceptionReporterCache;
import com.xunlei.channel.sms.health.exception.ExceptionReporterConfig;
import com.xunlei.channel.sms.health.exception.ExceptionType;
import com.xunlei.channel.sms.health.exception.ExceptionTypeCounter;
import java.io.IOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExceptionSmsHealthIndicator
implements SmsHealthIndicator {
    public static final String OK = "OK";
    private static final Logger logger = LoggerFactory.getLogger(ExceptionSmsHealthIndicator.class);
    @Autowired
    private ExceptionReporterCache exceptionReporterCache;
    @Autowired
    private ExceptionReporterConfig exceptionReporterConfig;

    @Override
    public String healthName() {
        return "exception-report";
    }

    @Override
    public SmsHealthInfo health() {
        boolean exceptionCounterHealth;
        Collection<ExceptionTypeCounter> counterCollection = null;
        try {
            counterCollection = this.getExceptionCounter();
            exceptionCounterHealth = this.isExceptionCounterHealth(counterCollection);
            if (logger.isDebugEnabled()) {
                logger.debug("ExceptionTypeCounter collection: {} returns health status: {}", counterCollection, (Object)exceptionCounterHealth);
            }
        }
        catch (CacheException e) {
            logger.error("Error happened when get cache. Message: " + e.getMessage(), (Throwable)e);
            exceptionCounterHealth = false;
        }
        catch (Exception e) {
            logger.error("Error happened when get health status. Message: " + e.getMessage(), (Throwable)e);
            return SmsHealthInfo.ok();
        }
        if (counterCollection == null) {
            return SmsHealthInfo.ok();
        }
        String message = this.buildMessage(counterCollection);
        String sortDescribe = this.buildSortDescribe(counterCollection);
        String describe = this.buildDescribe(sortDescribe, message);
        SmsHealthInfo smsHealthInfo = new SmsHealthInfo();
        smsHealthInfo.setHealth(exceptionCounterHealth);
        smsHealthInfo.setMessage(message);
        smsHealthInfo.setDescribe(describe);
        smsHealthInfo.setSortDescribe(sortDescribe);
        if (logger.isDebugEnabled()) {
            logger.debug("Build counterCollection: {} to healthInfo: {}", counterCollection, (Object)smsHealthInfo);
        }
        return smsHealthInfo;
    }

    public String buildMessage(Collection<ExceptionTypeCounter> counterCollection) {
        if (counterCollection == null) {
            return OK;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        String delimiter = "";
        for (ExceptionTypeCounter exceptionTypeCounter : counterCollection) {
            String counterMessage = this.buildCounterToMessage(exceptionTypeCounter);
            builder.append("\n - ").append(delimiter).append(counterMessage);
        }
        builder.append("\n");
        builder.append("}");
        String message = builder.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("Build counterCollection: {} to message: {}", counterCollection, (Object)message);
        }
        return message;
    }

    private String buildCounterToMessage(ExceptionTypeCounter exceptionTypeCounter) {
        StringBuilder builder = new StringBuilder();
        String parameterDelimiter = ", ";
        String deviceId = exceptionTypeCounter.getDeviceId();
        ExceptionType exceptionType = exceptionTypeCounter.getExceptionType();
        String message = exceptionType.getMessage();
        Long count = exceptionTypeCounter.getCount();
        builder.append("\u5f02\u5e38\u8bbe\u5907: ").append(deviceId).append(parameterDelimiter).append("\u5f02\u5e38\u7c7b\u578b: ").append(message).append(parameterDelimiter).append("\u5f02\u5e38\u6b21\u6570: ").append(count);
        return builder.toString();
    }

    public String buildSortDescribe(Collection<ExceptionTypeCounter> counterCollection) {
        long count = 0L;
        for (ExceptionTypeCounter exceptionTypeCounter : counterCollection) {
            if (exceptionTypeCounter == null) continue;
            Long countVar = exceptionTypeCounter.getCount();
            if (countVar == null) {
                countVar = 0L;
            }
            count += countVar.longValue();
        }
        StringBuilder builder = new StringBuilder();
        Integer triggerLeastSize = this.exceptionReporterConfig.getTriggerLeastSize();
        builder.append("\u5f02\u5e38\u4e0a\u62a5\u5f02\u5e38\u6b21\u6570\u8d85\u8fc7\u9884\u5b9a\u914d\u7f6e\u6b21\u6570:").append(triggerLeastSize).append(", \u603b\u5f02\u5e38\u6b21\u6570\uff1a").append(count);
        return builder.toString();
    }

    public String buildDescribe(String sortDescribe, String message) {
        StringBuilder builder = new StringBuilder();
        builder.append(sortDescribe).append(", \u5f02\u5e38\u4fe1\u606f\uff1a").append(message);
        return builder.toString();
    }

    private boolean isHealth() {
        try {
            Collection<ExceptionTypeCounter> exceptionCounter = this.getExceptionCounter();
            boolean exceptionCounterHealth = this.isExceptionCounterHealth(exceptionCounter);
            return exceptionCounterHealth;
        }
        catch (CacheException e) {
            logger.error("Error happened when get cache. Message: " + e.getMessage(), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return true;
        }
    }

    private Collection<ExceptionTypeCounter> getExceptionCounter() throws CacheException, IOException {
        Collection<ExceptionTypeCounter> exceptionTypeCounters = this.exceptionReporterCache.getExceptionCounterCollection();
        return exceptionTypeCounters;
    }

    private boolean isExceptionCounterHealth(Collection<ExceptionTypeCounter> exceptionTypeCounters) {
        Integer triggerLeastSize = this.exceptionReporterConfig.getTriggerLeastSize();
        if (exceptionTypeCounters == null) {
            return true;
        }
        for (ExceptionTypeCounter exceptionTypeCounter : exceptionTypeCounters) {
            Long count = exceptionTypeCounter.getCount();
            if (count == null || count <= (long)triggerLeastSize.intValue()) continue;
            return false;
        }
        return true;
    }
}

