/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.health.exception;

import com.xunlei.channel.sms.cache.CacheException;
import com.xunlei.channel.sms.cache.CacheService;
import com.xunlei.channel.sms.cache.CacheServiceProvider;
import com.xunlei.channel.sms.cache.vo.Cache;
import com.xunlei.channel.sms.health.exception.ExceptionType;
import com.xunlei.channel.sms.health.exception.ExceptionTypeCounter;
import com.xunlei.channel.sms.util.NetWorkUtils;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ExceptionReporterCache {
    private static final String CACHE_GROUP = "exception_report";
    private static final String HOST_NAME_AND_NAME_DELIMITER = ":";
    @Autowired
    private CacheServiceProvider cacheServiceProvider;
    private static final Logger logger = LoggerFactory.getLogger(ExceptionReporterCache.class);

    public String getCacheValue(ExceptionType type) throws CacheException {
        String cacheName = this.getCacheName(type);
        if (cacheName == null) {
            return null;
        }
        String cacheValue = this.getCacheService().getCacheValue(CACHE_GROUP, cacheName);
        if (logger.isDebugEnabled()) {
            logger.debug("Getting cache value: {} by group: {} and name: {}", new Object[]{cacheValue, CACHE_GROUP, cacheName});
        }
        return cacheValue;
    }

    public Collection<String> getCacheValues() throws CacheException {
        Collection cacheValuesByGroup = this.getCacheService().getCacheValuesByGroup(CACHE_GROUP);
        return cacheValuesByGroup;
    }

    public void setCacheValue(ExceptionType type, String cacheValue, int timeoutSeconds) throws CacheException {
        String cacheName = this.getCacheName(type);
        if (type == null || cacheName == null || StringUtils.isEmpty((Object)cacheValue)) {
            return;
        }
        Cache cache = new Cache(CACHE_GROUP, cacheName, cacheValue);
        this.getCacheService().setCache(cache);
        this.getCacheService().setExpire(CACHE_GROUP, (long)timeoutSeconds, TimeUnit.SECONDS);
        if (logger.isDebugEnabled()) {
            logger.debug("Settings cache value: {} by group: {} and name: {}", new Object[]{cacheValue, CACHE_GROUP, cacheName});
        }
    }

    public ExceptionTypeCounter getExceptionCounter(ExceptionType exceptionType) throws CacheException, IOException {
        String cacheValue = this.getCacheValue(exceptionType);
        if (StringUtils.isEmpty((Object)cacheValue)) {
            return null;
        }
        ExceptionTypeCounter exceptionTypeCounter = ExceptionTypeCounter.fromJson(cacheValue);
        if (logger.isDebugEnabled()) {
            logger.debug("Convert json string: {} to ExceptionTypeCounter: {}", (Object)cacheValue, (Object)exceptionTypeCounter);
        }
        return exceptionTypeCounter;
    }

    public Collection<ExceptionTypeCounter> getExceptionCounterCollection() throws CacheException, IOException {
        Collection<String> cacheValues = this.getCacheValues();
        if (cacheValues == null) {
            return null;
        }
        ArrayList<ExceptionTypeCounter> exceptionTypeCounters = new ArrayList<ExceptionTypeCounter>();
        for (String cacheValue : cacheValues) {
            ExceptionTypeCounter exceptionTypeCounter = ExceptionTypeCounter.fromJson(cacheValue);
            exceptionTypeCounters.add(exceptionTypeCounter);
        }
        return exceptionTypeCounters;
    }

    public void setExceptionTypeCounterCache(ExceptionTypeCounter counter, int timeoutSeconds) throws CacheException {
        String json = ExceptionTypeCounter.toJson(counter);
        ExceptionType exceptionType = counter.getExceptionType();
        this.setCacheValue(exceptionType, json, timeoutSeconds);
        if (logger.isDebugEnabled()) {
            logger.debug("Succeed set cache: {} by counter: {}", (Object)json, (Object)counter);
        }
    }

    private CacheService getCacheService() {
        return this.cacheServiceProvider.getCacheService();
    }

    private String getCacheName(ExceptionType type) throws CacheException {
        String hostName;
        if (type == null) {
            return null;
        }
        String name = type.name();
        try {
            hostName = NetWorkUtils.getHostName();
        }
        catch (UnknownHostException e) {
            logger.error("Could'nt get host. Error message: " + e.getMessage(), (Throwable)e);
            hostName = "unknown";
        }
        return hostName + HOST_NAME_AND_NAME_DELIMITER + name;
    }
}

