/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.health.exception;

import com.xunlei.channel.sms.cache.CacheException;
import com.xunlei.channel.sms.health.exception.ExceptionHealthEvent;
import com.xunlei.channel.sms.health.exception.ExceptionReporterCache;
import com.xunlei.channel.sms.health.exception.ExceptionReporterConfig;
import com.xunlei.channel.sms.health.exception.ExceptionType;
import com.xunlei.channel.sms.health.exception.ExceptionTypeCounter;
import com.xunlei.channel.sms.health.report.Reporter;
import com.xunlei.channel.sms.threadpool.asynchronous.AsynchronousInvokerService;
import com.xunlei.channel.sms.util.NetWorkUtils;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExceptionReporter
implements Reporter<ExceptionHealthEvent>,
BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionReporter.class);
    private static ExceptionReporter instance;
    @Autowired
    private ExceptionReporterConfig exceptionReporterConfig;
    @Autowired
    private ExceptionReporterCache exceptionReporterCache;
    @Autowired
    private AsynchronousInvokerService asynchronousInvokerService;

    public static void reportHealthEvent(ExceptionHealthEvent event) {
        ExceptionReporter reporter = ExceptionReporter.getReporter();
        reporter.report(event);
    }

    public static ExceptionReporter getReporter() {
        if (instance == null) {
            logger.error("ExceptionReporter is null!");
            throw new NullPointerException("ExceptionReporter is null!");
        }
        return instance;
    }

    @Override
    public void report(final ExceptionHealthEvent event) {
        this.asynchronousInvokerService.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    ExceptionTypeCounter exceptionCounter;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Putting event: {}", (Object)event);
                    }
                    try {
                        exceptionCounter = ExceptionReporter.this.getExceptionCounter(event);
                    }
                    catch (CacheException e) {
                        logger.error("Error when get cache. Error message: " + e.getMessage(), (Throwable)e);
                        return null;
                    }
                    exceptionCounter.setCount(exceptionCounter.getCount() + 1L);
                    exceptionCounter.setDeviceId(NetWorkUtils.getHostName());
                    try {
                        ExceptionReporter.this.putExceptionCounter(exceptionCounter);
                    }
                    catch (CacheException e) {
                        logger.error("Error when put cache. Error message: " + e.getMessage(), (Throwable)e);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Succeed put event: {}", (Object)event);
                    }
                }
                catch (Exception e) {
                    logger.error("Error when put event: " + event + " with message: " + e.getMessage(), (Throwable)e);
                }
                return null;
            }
        });
    }

    private ExceptionTypeCounter getExceptionCounter(ExceptionHealthEvent event) throws CacheException {
        ExceptionType exceptionType = event.getExceptionType();
        ExceptionTypeCounter exceptionCounter = null;
        try {
            exceptionCounter = this.exceptionReporterCache.getExceptionCounter(exceptionType);
        }
        catch (IOException e) {
            logger.error("Error when parse cache. Error message: " + e.getMessage(), (Throwable)e);
        }
        if (exceptionCounter == null) {
            exceptionCounter = new ExceptionTypeCounter();
            exceptionCounter.setExceptionType(exceptionType);
            exceptionCounter.setCount(0L);
        }
        return exceptionCounter;
    }

    private void putExceptionCounter(ExceptionTypeCounter exceptionTypeCounter) throws CacheException {
        Integer storageTimeSeconds = this.exceptionReporterConfig.getStorageTimeSeconds();
        this.exceptionReporterCache.setExceptionTypeCounterCache(exceptionTypeCounter, storageTimeSeconds);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        ExceptionReporter exceptionReporter = (ExceptionReporter)beanFactory.getBean(this.getClass());
        logger.info("Getting exceptionReporter bean: {}", (Object)exceptionReporter);
        instance = exceptionReporter;
    }
}

