/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.event.manager.impl;

import com.xunlei.channel.sms.entity.ReturnResult;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.event.SmsMessageAcceptEvent;
import com.xunlei.channel.sms.event.SmsMessageReceiveEvent;
import com.xunlei.channel.sms.event.SmsMessageRejectEvent;
import com.xunlei.channel.sms.event.SmsMessageSendEvent;
import com.xunlei.channel.sms.event.SmsMessageSendFailedEvent;
import com.xunlei.channel.sms.event.manager.SmsMessageEventManager;
import com.xunlei.channel.sms.threadpool.asynchronous.AsynchronousInvokerService;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class SmsMessageEventManagerImpl
implements SmsMessageEventManager {
    private static final Logger logger = LoggerFactory.getLogger(SmsMessageEventManagerImpl.class);
    private AsynchronousInvokerService asynchronousInvokerService;
    @Autowired(required=false)
    private List<SmsMessageReceiveEvent> receiveEvents;
    @Autowired(required=false)
    private List<SmsMessageRejectEvent> rejectEvents;
    @Autowired(required=false)
    private List<SmsMessageAcceptEvent> acceptEvents;
    @Autowired(required=false)
    private List<SmsMessageSendEvent> sendEvents;
    @Autowired(required=false)
    private List<SmsMessageSendFailedEvent> failedEvents;

    public SmsMessageEventManagerImpl(AsynchronousInvokerService asynchronousInvokerService) {
        this.asynchronousInvokerService = asynchronousInvokerService;
    }

    @Override
    public boolean receivedSmsMessage(final SmsMessageRequest message) {
        if (this.asynchronousInvokerService == null) {
            logger.error("AsynchronousInvokerService is null! so ignored notify to receive events!");
            return false;
        }
        if (CollectionUtils.isEmpty(this.receiveEvents)) {
            logger.debug("No receive events found, so ignored receive events!");
            return true;
        }
        boolean submit = this.asynchronousInvokerService.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                for (SmsMessageReceiveEvent receiveEvent : SmsMessageEventManagerImpl.this.receiveEvents) {
                    try {
                        boolean success = receiveEvent.receivedSmsMessage(message);
                        if (success) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Success to notify message: {} to listener: {}", (Object)message, (Object)receiveEvent);
                            continue;
                        }
                        logger.warn("Failed to notify message: {} to listener: {}", (Object)message, (Object)receiveEvent);
                    }
                    catch (Exception e) {
                        logger.error("Caught a exception when notify message: " + message + " to listener: " + receiveEvent + " error: " + e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
                return true;
            }
        });
        if (submit) {
            if (logger.isDebugEnabled()) {
                logger.debug("Success to submit message: {} to listeners.", (Object)message);
            }
        } else {
            logger.error("Failed to submit message: {} to listeners.", (Object)message);
        }
        return submit;
    }

    @Override
    public boolean acceptedSmsMessage(final SmsMessageRequest message) {
        if (this.asynchronousInvokerService == null) {
            logger.error("AsynchronousInvokerService is null! so ignored notify to receive events!");
            return false;
        }
        if (CollectionUtils.isEmpty(this.acceptEvents)) {
            logger.debug("No accept events found, so ignored receive events!");
            return true;
        }
        boolean submit = this.asynchronousInvokerService.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                for (SmsMessageAcceptEvent acceptEvent : SmsMessageEventManagerImpl.this.acceptEvents) {
                    try {
                        boolean success = acceptEvent.acceptedSmsMessage(message);
                        if (success && logger.isDebugEnabled()) {
                            logger.debug("Success to notify message: {} to listener: {}", (Object)message, (Object)acceptEvent);
                            continue;
                        }
                        if (success) continue;
                        logger.warn("Failed to notify message: {} to listener: {}", (Object)message, (Object)acceptEvent);
                    }
                    catch (Exception e) {
                        logger.error("Caught a exception when notify message: " + message + " to listener: " + acceptEvent + " error: " + e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
                return true;
            }
        });
        if (submit) {
            if (logger.isDebugEnabled()) {
                logger.debug("Success to submit message: {} to listeners.", (Object)message);
            }
        } else {
            logger.error("Failed to submit message: {} to listeners.", (Object)message);
        }
        return submit;
    }

    @Override
    public boolean sentSmsMessage(final SmsMessageRequest message) {
        if (this.asynchronousInvokerService == null) {
            logger.error("AsynchronousInvokerService is null! so ignored notify to send events!");
            return false;
        }
        if (CollectionUtils.isEmpty(this.sendEvents)) {
            logger.debug("No send events found, so ignored send events!");
            return true;
        }
        boolean submit = this.asynchronousInvokerService.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                for (SmsMessageSendEvent sendEvent : SmsMessageEventManagerImpl.this.sendEvents) {
                    try {
                        boolean success = sendEvent.sentSmsMessage(message);
                        if (success) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Success to notify message: {} to listener: {}", (Object)message, (Object)sendEvent);
                            continue;
                        }
                        logger.warn("Failed to notify message: {} to listener: {}", (Object)message, (Object)sendEvent);
                    }
                    catch (Exception e) {
                        logger.error("Caught a exception when notify message: " + message + " to listener: " + sendEvent + " error: " + e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
                return true;
            }
        });
        if (submit) {
            if (logger.isDebugEnabled()) {
                logger.debug("Success to submit message: {} to listeners.", (Object)message);
            }
        } else {
            logger.error("Failed to submit message: {} to listeners.", (Object)message);
        }
        return submit;
    }

    @Override
    public boolean rejectedSmsMessage(final SmsMessageRequest message, final ReturnResult reason) {
        if (this.asynchronousInvokerService == null) {
            logger.error("AsynchronousInvokerService is null! so ignored notify to reject events!");
            return false;
        }
        if (CollectionUtils.isEmpty(this.rejectEvents)) {
            logger.debug("No reject events found, so ignored reject events!");
            return true;
        }
        boolean submit = this.asynchronousInvokerService.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                for (SmsMessageRejectEvent rejectEvent : SmsMessageEventManagerImpl.this.rejectEvents) {
                    try {
                        boolean success = rejectEvent.rejectedSmsMessage(message, reason);
                        if (success) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Success to notify message: {} to listener: {}", (Object)message, (Object)rejectEvent);
                            continue;
                        }
                        logger.warn("Failed to notify message: {} to listener: {}", (Object)message, (Object)rejectEvent);
                    }
                    catch (Exception e) {
                        logger.error("Caught a exception when notify message: " + message + " to listener: " + rejectEvent + " error: " + e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
                return true;
            }
        });
        if (submit) {
            if (logger.isDebugEnabled()) {
                logger.debug("Success to submit message: {} to listeners.", (Object)message);
            }
        } else {
            logger.error("Failed to submit message: {} to listeners.", (Object)message);
        }
        return submit;
    }

    @Override
    public boolean failedToSendSmsMessage(final SmsMessageRequest message, final ReturnResult reason) {
        if (this.asynchronousInvokerService == null) {
            logger.error("AsynchronousInvokerService is null! so ignored notify to fail events!");
            return false;
        }
        if (CollectionUtils.isEmpty(this.failedEvents)) {
            logger.debug("No fail events found, so ignored fail events!");
            return true;
        }
        boolean submit = this.asynchronousInvokerService.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                for (SmsMessageSendFailedEvent failedEvent : SmsMessageEventManagerImpl.this.failedEvents) {
                    try {
                        boolean success = failedEvent.failedToSendSmsMessage(message, reason);
                        if (success) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Success to notify message: {} to listener: {}", (Object)message, (Object)failedEvent);
                            continue;
                        }
                        logger.warn("Failed to notify message: {} to listener: {}", (Object)message, (Object)failedEvent);
                    }
                    catch (Exception e) {
                        logger.error("Caught a exception when notify message: " + message + " to listener: " + failedEvent + " error: " + e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
                return true;
            }
        });
        if (submit) {
            if (logger.isDebugEnabled()) {
                logger.debug("Success to submit message: {} to listeners.", (Object)message);
            }
        } else {
            logger.error("Failed to submit message: {} to listeners.", (Object)message);
        }
        return submit;
    }

    public void setAsynchronousInvokerService(AsynchronousInvokerService asynchronousInvokerService) {
        this.asynchronousInvokerService = asynchronousInvokerService;
    }

    public List<SmsMessageReceiveEvent> getReceiveEvents() {
        return this.receiveEvents;
    }

    public void setReceiveEvents(List<SmsMessageReceiveEvent> receiveEvents) {
        this.receiveEvents = receiveEvents;
    }

    public List<SmsMessageRejectEvent> getRejectEvents() {
        return this.rejectEvents;
    }

    public void setRejectEvents(List<SmsMessageRejectEvent> rejectEvents) {
        this.rejectEvents = rejectEvents;
    }

    public List<SmsMessageAcceptEvent> getAcceptEvents() {
        return this.acceptEvents;
    }

    public void setAcceptEvents(List<SmsMessageAcceptEvent> acceptEvents) {
        this.acceptEvents = acceptEvents;
    }

    public List<SmsMessageSendEvent> getSendEvents() {
        return this.sendEvents;
    }

    public void setSendEvents(List<SmsMessageSendEvent> sendEvents) {
        this.sendEvents = sendEvents;
    }

    public List<SmsMessageSendFailedEvent> getFailedEvents() {
        return this.failedEvents;
    }

    public void setFailedEvents(List<SmsMessageSendFailedEvent> failedEvents) {
        this.failedEvents = failedEvents;
    }
}

