/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.support;

import com.xunlei.channel.sms.vo.SmsMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpMessageUtils {
    private static final Logger logger = LoggerFactory.getLogger(SpMessageUtils.class);

    public static Collection<SmsMessage> getRemovedDuplicateMobileAndContentSet(Collection<SmsMessage> messages) {
        ArrayList<SmsMessage> result = new ArrayList<SmsMessage>();
        HashSet<String> mobileAndContentSet = new HashSet<String>();
        for (SmsMessage smsMessage : messages) {
            String mobile = smsMessage.getMobile();
            String content = smsMessage.getContent();
            String pair = mobile + "|" + content;
            if (mobileAndContentSet.contains(pair)) {
                logger.warn("Removed duplicate mobile: {} content: {}", (Object)mobile, (Object)content);
                continue;
            }
            mobileAndContentSet.add(pair);
            result.add(smsMessage);
        }
        return result;
    }

    public static Collection<SmsMessage> getDuplicateMobileRequests(Collection<SmsMessage> messageRequests) {
        HashMap<String, ArrayList<SmsMessage>> mobileMessagesMap = new HashMap<String, ArrayList<SmsMessage>>();
        for (SmsMessage messageRequest : messageRequests) {
            String mobile = messageRequest.getMobile();
            ArrayList<SmsMessage> messageRequestCollection = (ArrayList<SmsMessage>)mobileMessagesMap.get(mobile);
            if (messageRequestCollection == null) {
                messageRequestCollection = new ArrayList<SmsMessage>();
            }
            messageRequestCollection.add(messageRequest);
            mobileMessagesMap.put(mobile, messageRequestCollection);
        }
        ArrayList<SmsMessage> rs = new ArrayList<SmsMessage>();
        for (Map.Entry mobileSizeEntry : mobileMessagesMap.entrySet()) {
            String mobile = (String)mobileSizeEntry.getKey();
            Collection messageRequestCollection = (Collection)mobileSizeEntry.getValue();
            if (messageRequestCollection == null || messageRequestCollection.size() <= 1) continue;
            logger.info("Found duplicate mobile: {} ", (Object)mobile);
            rs.addAll(messageRequestCollection);
            SpMessageUtils.removeMessageRequestByMobile(messageRequests, mobile);
        }
        return rs;
    }

    private static void removeMessageRequestByMobile(Collection<SmsMessage> messageRequests, String mobile) {
        Iterator<SmsMessage> iterator = messageRequests.iterator();
        while (iterator.hasNext()) {
            SmsMessage messageRequest = iterator.next();
            if (!mobile.equals(messageRequest.getMobile())) continue;
            iterator.remove();
        }
    }
}

