/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.support;

import com.xunlei.channel.sms.constants.SmsCarriers;
import com.xunlei.channel.sms.constants.SmsStatus;
import com.xunlei.channel.sms.constants.SmsType;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public abstract class MessageRequestConvertUtil {
    public static List<SmsMessage> convertMessageRequestToSmsMessage(SmsMessageRequest messageRequest) {
        if (messageRequest == null) {
            return null;
        }
        String mobiles = messageRequest.getMobiles();
        String uids = messageRequest.getUserId();
        if (StringUtils.hasText((String)mobiles)) {
            String[] mobileArray = mobiles.split(",");
            String[] uniqueMobiles = MessageRequestConvertUtil.unique(mobileArray);
            if (StringUtils.hasText((String)uids) && mobiles.contains(",") && uids.contains(",")) {
                String[] uidArray = uids.split(",");
                String[] uniqueUids = MessageRequestConvertUtil.unique(uidArray);
                return MessageRequestConvertUtil.convertMessageRequestToSmsMessageWithMobilesAndUids(messageRequest, uniqueMobiles, uniqueUids);
            }
            return MessageRequestConvertUtil.convertMessageRequestToSmsMessageWithMobiles(messageRequest, uniqueMobiles);
        }
        return MessageRequestConvertUtil.convertMessageRequestToSmsMessageWithMobiles(messageRequest, messageRequest.getMobile());
    }

    private static String[] unique(String[] mobiles) {
        if (mobiles.length > 1) {
            LinkedHashSet<String> mobileSet = new LinkedHashSet<String>();
            for (String mobile : mobiles) {
                mobileSet.add(mobile);
            }
            return mobileSet.toArray(new String[0]);
        }
        return mobiles;
    }

    private static List<SmsMessage> convertMessageRequestToSmsMessageWithMobiles(SmsMessageRequest messageRequest, String ... mobiles) {
        if (mobiles == null || mobiles.length == 0) {
            return null;
        }
        ArrayList<SmsMessage> smsMessages = new ArrayList<SmsMessage>(mobiles.length);
        for (String mobile : mobiles) {
            SmsMessage smsMessage = MessageRequestConvertUtil.convertMessageRequestToSmsMessage(messageRequest, mobile, null);
            smsMessages.add(smsMessage);
        }
        return smsMessages;
    }

    private static List<SmsMessage> convertMessageRequestToSmsMessageWithMobilesAndUids(SmsMessageRequest messageRequest, String[] mobiles, String[] uid) {
        if (mobiles == null || mobiles.length == 0) {
            return null;
        }
        if (uid == null || uid.length == 0) {
            return null;
        }
        if (mobiles.length != uid.length) {
            return null;
        }
        ArrayList<SmsMessage> smsMessages = new ArrayList<SmsMessage>(mobiles.length);
        for (int i = 0; i < mobiles.length; ++i) {
            SmsMessage smsMessage = MessageRequestConvertUtil.convertMessageRequestToSmsMessage(messageRequest, mobiles[i], uid[i]);
            smsMessages.add(smsMessage);
        }
        return smsMessages;
    }

    private static SmsMessage convertMessageRequestToSmsMessage(SmsMessageRequest messageRequest, String mobile, String uid) {
        SmsType smsType;
        SmsCarriers smsCarriers;
        SmsStatus smsStatus;
        SmsMessage smsMessage = new SmsMessage();
        BeanUtils.copyProperties((Object)messageRequest, (Object)smsMessage);
        smsMessage.setMobile(mobile);
        smsMessage.setCallbackUrl(messageRequest.getCallbackUrl());
        if (StringUtils.hasText((String)uid)) {
            smsMessage.setUserId(uid);
        }
        if ((smsStatus = messageRequest.getSmsStatus()) != null) {
            smsMessage.setSmsStatus(smsStatus.getStatus());
        }
        if ((smsCarriers = messageRequest.getSmsCarriers()) != null) {
            smsMessage.setSmsCarriers(smsCarriers.getCarriers());
        }
        if ((smsType = messageRequest.getSmsType()) != null) {
            smsMessage.setSmsType(smsType.getType());
        }
        return smsMessage;
    }
}

