/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.entity;

import com.xunlei.channel.sms.constants.SmsStatus;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MtResult {
    private String uniqueNumber;
    private String spId;
    private String mobile;
    private String spBatchId;
    private String spMessageId;
    private SmsStatus smsStatus;
    private String result;

    public String getUniqueNumber() {
        return this.uniqueNumber;
    }

    public void setUniqueNumber(String uniqueNumber) {
        this.uniqueNumber = uniqueNumber;
    }

    public String getSpId() {
        return this.spId;
    }

    public void setSpId(String spId) {
        this.spId = spId;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getSpMessageId() {
        return this.spMessageId;
    }

    public void setSpMessageId(String spMessageId) {
        this.spMessageId = spMessageId;
    }

    public SmsStatus getSmsStatus() {
        return this.smsStatus;
    }

    public void setSmsStatus(SmsStatus smsStatus) {
        this.smsStatus = smsStatus;
    }

    public String getSpBatchId() {
        return this.spBatchId;
    }

    public void setSpBatchId(String spBatchId) {
        this.spBatchId = spBatchId;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MtResult mtResult = (MtResult)o;
        if (this.uniqueNumber != null ? !this.uniqueNumber.equals(mtResult.uniqueNumber) : mtResult.uniqueNumber != null) {
            return false;
        }
        if (this.spId != null ? !this.spId.equals(mtResult.spId) : mtResult.spId != null) {
            return false;
        }
        if (this.mobile != null ? !this.mobile.equals(mtResult.mobile) : mtResult.mobile != null) {
            return false;
        }
        if (this.spBatchId != null ? !this.spBatchId.equals(mtResult.spBatchId) : mtResult.spBatchId != null) {
            return false;
        }
        if (this.spMessageId != null ? !this.spMessageId.equals(mtResult.spMessageId) : mtResult.spMessageId != null) {
            return false;
        }
        if (this.smsStatus != mtResult.smsStatus) {
            return false;
        }
        return this.result != null ? this.result.equals(mtResult.result) : mtResult.result == null;
    }

    public int hashCode() {
        int result1 = this.uniqueNumber != null ? this.uniqueNumber.hashCode() : 0;
        result1 = 31 * result1 + (this.spId != null ? this.spId.hashCode() : 0);
        result1 = 31 * result1 + (this.mobile != null ? this.mobile.hashCode() : 0);
        result1 = 31 * result1 + (this.spBatchId != null ? this.spBatchId.hashCode() : 0);
        result1 = 31 * result1 + (this.spMessageId != null ? this.spMessageId.hashCode() : 0);
        result1 = 31 * result1 + (this.smsStatus != null ? this.smsStatus.hashCode() : 0);
        result1 = 31 * result1 + (this.result != null ? this.result.hashCode() : 0);
        return result1;
    }

    public String toString() {
        return "MtResult{uniqueNumber='" + this.uniqueNumber + '\'' + ", spId='" + this.spId + '\'' + ", mobile='" + this.mobile + '\'' + ", spBatchId='" + this.spBatchId + '\'' + ", spMessageId='" + this.spMessageId + '\'' + ", smsStatus=" + (Object)((Object)this.smsStatus) + ", result='" + this.result + '\'' + '}';
    }

    public static MtResult errorResult() {
        MtResult mtResult = new MtResult();
        mtResult.setSmsStatus(SmsStatus.FAIL);
        return mtResult;
    }

    public static void updateMessageResult(Collection<SmsMessage> messages, MtResult mtResult) {
        if (CollectionUtils.isEmpty(messages) || mtResult == null) {
            return;
        }
        String spBatchId = mtResult.getSpBatchId();
        for (SmsMessage message : messages) {
            String spMessageId = message.buildSpMessageId(spBatchId);
            message.setSmsStatus(mtResult.getSmsStatus() == null ? null : mtResult.getSmsStatus().getStatus());
            message.setSpMessageId(spMessageId);
            message.setResult(mtResult.getResult());
        }
    }

    public static List<MtResult> buildMtResult(List<SmsMessage> smsMessages, SmsStatus smsStatus, String spBatchId) {
        ArrayList<MtResult> mtResults = new ArrayList<MtResult>(smsMessages.size());
        for (SmsMessage smsMessage : smsMessages) {
            mtResults.add(MtResult.buildMtResult(smsMessage, smsStatus, spBatchId));
        }
        return mtResults;
    }

    public static MtResult buildMtResult(SmsMessage smsMessage, SmsStatus smsStatus, String spBatchId) {
        MtResult mtResult = new MtResult();
        mtResult.setMobile(smsMessage.getMobile());
        mtResult.setUniqueNumber(smsMessage.getUniqueNumber());
        mtResult.setSpId(smsMessage.getSpId());
        if (StringUtils.hasText((String)spBatchId)) {
            mtResult.setSpMessageId(smsMessage.buildSpMessageId(spBatchId));
        }
        mtResult.setSpBatchId(spBatchId);
        mtResult.setSmsStatus(smsStatus);
        return mtResult;
    }

    public static MtResult buildMtResult(String mobile, String uniqueNumber, String spId, String spClass, String spBatchId, SmsStatus smsStatus) {
        MtResult mtResult = new MtResult();
        mtResult.setMobile(mobile);
        mtResult.setUniqueNumber(uniqueNumber);
        mtResult.setSpId(spId);
        if (StringUtils.hasText((String)spBatchId)) {
            mtResult.setSpMessageId(SmsMessage.buildSpMessageId(spBatchId, spClass, mobile));
        }
        mtResult.setSpBatchId(spBatchId);
        mtResult.setSmsStatus(smsStatus);
        return mtResult;
    }
}

