/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.dao;

import com.xunlei.channel.sms.dao.BaseDao;
import com.xunlei.channel.sms.entity.ConfigInfo;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Repository
public class ConfigDao
extends BaseDao<ConfigInfo> {
    public ConfigInfo saveConfig(ConfigInfo configInfo) {
        GeneratedKeyHolder keyHolder = this.updateAndReturnGeneratedKeyHolder("insert into config_info(config_group, config_name, config_value, config_describe) values (:configGroup, :configName, :configValue, :configDescribe)", configInfo);
        ConfigInfo result = new ConfigInfo();
        BeanUtils.copyProperties((Object)configInfo, (Object)result);
        Number key = keyHolder.getKey();
        result.setConfigId(Long.valueOf(key.longValue()));
        return result;
    }

    public ConfigInfo getConfig(ConfigInfo configInfo) {
        Assert.notNull((Object)configInfo);
        Assert.hasText((String)configInfo.getConfigGroup());
        Assert.hasText((String)configInfo.getConfigName());
        List<ConfigInfo> configInfoList = this.query("select config_id, config_group, config_name, config_value, config_describe from config_info where config_group=:configGroup and config_name=:configName", configInfo);
        if (CollectionUtils.isEmpty(configInfoList)) {
            return null;
        }
        ConfigInfo result = configInfoList.get(0);
        return result;
    }

    public List<ConfigInfo> getConfigInfoListByConfigName(String configName) {
        Assert.hasText((String)configName);
        List<Object[]> result = this.query("select config_id, config_group, config_name, config_value, config_describe from config_info where config_name=?", new Object[]{configName});
        return result;
    }

    public List<ConfigInfo> getConfigInfoListByConfigGroup(String configGroup) {
        Assert.hasText((String)configGroup);
        List<Object[]> result = this.query("select config_id, config_group, config_name, config_value, config_describe from config_info where config_group=?", new Object[]{configGroup});
        return result;
    }

    public int updateConfigByConfigNameAndValue(ConfigInfo configInfo) {
        Assert.notNull((Object)configInfo, (String)"ConfigInfo is null!");
        Assert.notNull((Object)configInfo.getConfigGroup(), (String)"Config group is null!");
        Assert.notNull((Object)configInfo.getConfigName(), (String)"Config name is null!");
        return this.update("update config_info set config_value=:configValue, config_describe=:configDescribe where config_group=:configGroup and config_name=:configName", configInfo);
    }
}

