/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.dao;

import com.xunlei.channel.sms.util.JacksonHelper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public abstract class BaseDao<T> {
    private static final Logger logger = LoggerFactory.getLogger(BaseDao.class);
    @Autowired
    @Qualifier(value="template")
    protected JdbcTemplate jdbcTemplate;
    @Autowired
    @Qualifier(value="namedParameterJdbcTemplate")
    protected NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private Class<T> pojoType;

    public BaseDao() {
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        try {
            Type type = ((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
            this.pojoType = (Class)type;
            logger.info("constructor... genericSuperclass: {}, pojoType: {}", (Object)genericSuperclass, this.pojoType);
        }
        catch (ClassCastException e) {
            logger.error("subclass must preset a generic class!", (Throwable)e);
        }
    }

    protected List<T> query(String sql, Object ... args) {
        List result = this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(this.pojoType), args);
        if (logger.isDebugEnabled()) {
            logger.debug("query... sql: {}, args: {} result: {}", new Object[]{sql, args, JacksonHelper.getJsonString((Object)result)});
        }
        return result;
    }

    protected List<T> query(String sql, T t) {
        try {
            BeanPropertySqlParameterSource parameterSource = new BeanPropertySqlParameterSource(t);
            BeanPropertyRowMapper beanPropertyRowMapper = new BeanPropertyRowMapper(this.pojoType);
            List result = this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameterSource, (RowMapper)beanPropertyRowMapper);
            if (logger.isDebugEnabled()) {
                logger.debug("queryForObject... sql: {}, args: {}, result: {}", new Object[]{sql, t, JacksonHelper.getJsonString((Object)result)});
            }
            return result;
        }
        catch (EmptyResultDataAccessException e) {
            logger.error("", (Throwable)e);
            return new ArrayList();
        }
    }

    protected T queryForObject(String sql, Object ... args) {
        try {
            Object result = this.jdbcTemplate.queryForObject(sql, (RowMapper)new BeanPropertyRowMapper(this.pojoType), args);
            if (logger.isDebugEnabled()) {
                logger.debug("queryForObject... sql: {}, args: {}, result: {}", new Object[]{sql, args, JacksonHelper.getJsonString((Object)result)});
            }
            return (T)result;
        }
        catch (EmptyResultDataAccessException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    protected T queryForObject(String sql, T t) {
        try {
            BeanPropertySqlParameterSource parameterSource = new BeanPropertySqlParameterSource(t);
            BeanPropertyRowMapper beanPropertyRowMapper = new BeanPropertyRowMapper(this.pojoType);
            Object result = this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameterSource, (RowMapper)beanPropertyRowMapper);
            if (logger.isDebugEnabled()) {
                logger.debug("queryForObject... sql: {}, args: {}, result: {}", new Object[]{sql, t, JacksonHelper.getJsonString((Object)result)});
            }
            return (T)result;
        }
        catch (EmptyResultDataAccessException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    protected int update(String sql, Object ... args) {
        int update = this.jdbcTemplate.update(sql, args);
        if (logger.isDebugEnabled()) {
            logger.debug("update... sql: {}, args: {} result: {}", new Object[]{sql, args, update});
        }
        return update;
    }

    protected int update(String sql, T t) {
        BeanPropertySqlParameterSource parameterSource = new BeanPropertySqlParameterSource(t);
        int update = this.namedParameterJdbcTemplate.update(sql, (SqlParameterSource)parameterSource);
        if (logger.isDebugEnabled()) {
            logger.debug("update... sql: {}, args: {} result: {}", new Object[]{sql, t, update});
        }
        return update;
    }

    protected int[] batchUpdate(String sql, T[] t) {
        int length = t.length;
        BeanPropertySqlParameterSource[] parameterSources = new BeanPropertySqlParameterSource[length];
        for (int i = 0; i < t.length; ++i) {
            parameterSources[i] = new BeanPropertySqlParameterSource(t[i]);
        }
        int[] updates = this.namedParameterJdbcTemplate.batchUpdate(sql, (SqlParameterSource[])parameterSources);
        if (logger.isDebugEnabled()) {
            logger.debug("update... sql: {}, args: {} result: {}", new Object[]{sql, t, Arrays.toString(updates)});
        }
        return updates;
    }

    protected int[] updateEntities(String sql, T[] array) {
        BeanPropertySqlParameterSource[] parameterSources = new BeanPropertySqlParameterSource[array.length];
        for (int i = 0; i < array.length; ++i) {
            BeanPropertySqlParameterSource sqlParameterSource;
            parameterSources[i] = sqlParameterSource = new BeanPropertySqlParameterSource(array[i]);
        }
        int[] update = this.namedParameterJdbcTemplate.batchUpdate(sql, (SqlParameterSource[])parameterSources);
        if (logger.isDebugEnabled()) {
            logger.debug("update... sql: {}, args: {} result: {}", new Object[]{sql, Arrays.toString(array), Arrays.toString(update)});
        }
        return update;
    }

    protected GeneratedKeyHolder updateAndReturnGeneratedKeyHolder(String sql, int[] types, Object[] parameters) {
        PreparedStatementCreatorFactory factory = new PreparedStatementCreatorFactory(sql, types);
        PreparedStatementCreator preparedStatementCreator = factory.newPreparedStatementCreator(parameters);
        GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
        int update = this.jdbcTemplate.update(preparedStatementCreator, (KeyHolder)generatedKeyHolder);
        if (logger.isDebugEnabled()) {
            logger.debug("update... sql: {}, types: {}, parameters: {}, updates: {}, generatedKeyHolder: {}", new Object[]{sql, Arrays.toString(types), Arrays.toString(parameters), update, generatedKeyHolder});
        }
        return generatedKeyHolder;
    }

    protected GeneratedKeyHolder updateAndReturnGeneratedKeyHolder(String sql, T entity) {
        BeanPropertySqlParameterSource parameterSource = new BeanPropertySqlParameterSource(entity);
        GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
        int update = this.namedParameterJdbcTemplate.update(sql, (SqlParameterSource)parameterSource, (KeyHolder)generatedKeyHolder);
        if (logger.isDebugEnabled()) {
            logger.debug("update... sql: {}, parameters: {}, updates: {}, generatedKeyHolder: {}", new Object[]{sql, entity, update, generatedKeyHolder});
        }
        return generatedKeyHolder;
    }
}

