/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.service;

import com.xunlei.channel.sms.dao.ConfigDao;
import com.xunlei.channel.sms.entity.ConfigInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ConfigService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigService.class);
    @Autowired
    private ConfigDao configDao;

    public String setConfig(String configGroup, String configName, String configValue) {
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setConfigGroup(configGroup);
        configInfo.setConfigName(configName);
        configInfo.setConfigValue(configValue);
        ConfigInfo configFromDb = this.getConfigFromDb(configGroup, configName);
        int i = this.configDao.updateConfigByConfigNameAndValue(configInfo);
        if (i != 1) {
            logger.warn("Update config abnormal! configValue: {}, configGroup: {}, configName: {}", new Object[]{configValue, configGroup, configName});
        }
        return configFromDb.getConfigValue();
    }

    public String getConfig(String configGroup, String configName) {
        String configValue;
        Assert.hasText((String)configGroup);
        Assert.hasText((String)configName);
        ConfigInfo configFromDb = this.getConfigFromDb(configGroup, configName);
        if (configFromDb == null) {
            logger.error("Getting config from database error, cause does'nt exists ConfigGroup: {} and ConfigName: {}", (Object)configGroup, (Object)configName);
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got config: {} from database.", (Object)configFromDb);
        }
        if ((configValue = configFromDb.getConfigValue()) == null) {
            return null;
        }
        return configValue;
    }

    public List<ConfigInfo> getConfigByName(String configName) {
        List<ConfigInfo> configInfoListByConfigName = this.configDao.getConfigInfoListByConfigName(configName);
        return configInfoListByConfigName;
    }

    public List<ConfigInfo> getConfigByGroup(String configGroup) {
        List<ConfigInfo> configInfoList = this.configDao.getConfigInfoListByConfigGroup(configGroup);
        return configInfoList;
    }

    public ConfigInfo getConfigFromDb(String configGroup, String configName) {
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setConfigGroup(configGroup);
        configInfo.setConfigName(configName);
        ConfigInfo config = this.configDao.getConfig(configInfo);
        return config;
    }

    public boolean clearCache() {
        return true;
    }
}

