/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.dao;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.xunlei.channel.sms.dao.BaseDao;
import com.xunlei.channel.sms.vo.MoMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository
public class MoMessageDao
extends BaseDao<MoMessage> {
    public void saveMoMessages(List<MoMessage> messages) {
        Assert.notEmpty(messages, (String)"messages collection is empty!");
        String sql = "INSERT INTO sms_mo_message (sp_id,mobile,content,mo_status,sp_message_id,receive_time,ext1,ext2,ext3) VALUES (:spId,:mobile,:content,:moStatus,:spMessageId,:receiveTime,:ext1,:ext2,:ext3)";
        this.batchUpdate(sql, messages.toArray(new MoMessage[messages.size()]));
    }

    public List<MoMessage> getMoMessagesBySpId(String spId) {
        Assert.notNull((Object)spId, (String)"spId could'nt be null!");
        List<Object[]> moMessages = this.query("SELECT * FROM sms_mo_message WHERE sp_id=? ORDER BY receive_time ", new Object[]{spId});
        return moMessages;
    }

    public List<MoMessage> getMoMessages(MoMessage moMessage, int limit, int offset) {
        Assert.notNull((Object)moMessage, (String)"moMessage could'nt be null!");
        StringBuffer sql = new StringBuffer("SELECT * FROM sms_mo_message WHERE 1=1 ");
        HashMap params = Maps.newHashMap();
        if (!Strings.isNullOrEmpty((String)moMessage.getMobile())) {
            params.put("mobile", moMessage.getMobile());
            sql.append("and ").append("mobile=:mobile ");
        }
        if (!Strings.isNullOrEmpty((String)moMessage.getSpId())) {
            params.put("sp_id", moMessage.getSpId());
            sql.append("and ").append("sp_id=:sp_id ");
        }
        if (!Strings.isNullOrEmpty((String)moMessage.getReceiveTime())) {
            String receiveTime = moMessage.getReceiveTime();
            String[] receiveTimeArray = receiveTime.split(",");
            String[] markArray = new String[]{">", "<="};
            int i = 0;
            while (i < receiveTimeArray.length) {
                if (!Strings.isNullOrEmpty((String)receiveTimeArray[i])) {
                    params.put("receive_time" + i, receiveTimeArray[i]);
                    sql.append("and ").append("receive_time" + markArray[i] + ":receive_time" + i).append(" ");
                }
                if (++i != markArray.length) continue;
            }
        }
        sql.append("order by receive_time desc ");
        sql.append("limit " + limit).append(" ");
        sql.append("offset " + offset).append(" ");
        List moMessages = this.namedParameterJdbcTemplate.query(sql.toString(), (Map)params, (RowMapper)new BeanPropertyRowMapper(MoMessage.class));
        return moMessages;
    }

    public long getSmsMoCount(MoMessage moMessage) {
        Number number;
        Assert.notNull((Object)moMessage, (String)"moMessage could'nt be null!");
        StringBuffer sql = new StringBuffer("SELECT count(*) FROM sms_mo_message WHERE 1=1 ");
        HashMap params = Maps.newHashMap();
        if (!Strings.isNullOrEmpty((String)moMessage.getMobile())) {
            params.put("mobile", moMessage.getMobile());
            sql.append("and ").append("mobile=:mobile ");
        }
        if (!Strings.isNullOrEmpty((String)moMessage.getSpId())) {
            params.put("sp_id", moMessage.getSpId());
            sql.append("and ").append("sp_id=:sp_id ");
        }
        if (!Strings.isNullOrEmpty((String)moMessage.getReceiveTime())) {
            String receiveTime = moMessage.getReceiveTime();
            String[] receiveTimeArray = receiveTime.split(",");
            String[] markArray = new String[]{">", "<="};
            int i = 0;
            while (i < receiveTimeArray.length) {
                if (!Strings.isNullOrEmpty((String)receiveTimeArray[i])) {
                    params.put("receive_time" + i, receiveTimeArray[i]);
                    sql.append("and ").append("receive_time" + markArray[i] + ":receive_time" + i).append(" ");
                }
                if (++i != markArray.length) continue;
            }
        }
        return (number = (Number)this.namedParameterJdbcTemplate.queryForObject(sql.toString(), (Map)params, Integer.class)) != null ? number.longValue() : 0L;
    }
}

