/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.dao;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xunlei.channel.sms.dao.BaseDao;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository
public class SmsMessageDao
extends BaseDao<SmsMessage> {
    public void saveSmsMessages(List<SmsMessage> messages) {
        Assert.notEmpty(messages, (String)"SmsMessage collection is empty!");
        String sql = "INSERT INTO sms_message(unique_number, sms_type, sp_id, sp_class, sp_message_id, biz_no,  user_id, mobile, content, input_time, sent_time, version, page_charset, user_ip, device_id, sms_status, result, ext_json, sent_date, billing_count, callback_url, receive_time, form) values (:uniqueNumber, :smsType, :spId, :spClass, :spMessageId, :bizNo, :userId, :mobile, :content, :inputTime, :sentTime, :version, :pageCharset, :userIp, :deviceId, :smsStatus, :result, :extJson, :sentDate, :billingCount,:callbackUrl, :receiveTime, :form)";
        this.batchUpdate(sql, messages.toArray(new SmsMessage[messages.size()]));
    }

    public void updateMessageStatusAndResultByUniqueNumber(List<SmsMessage> messages) {
        Assert.notEmpty(messages, (String)"SmsMessage collection is empty!");
        String sql = "UPDATE sms_message SET sms_status=:smsStatus, result=:result WHERE unique_number=:uniqueNumber";
        this.batchUpdate(sql, messages.toArray(new SmsMessage[messages.size()]));
    }

    public void updateSmsMessages(List<SmsMessage> messages) {
        Assert.notEmpty(messages, (String)"SmsMessage collection is empty!");
        String sql = "UPDATE sms_message SET  sms_type=:smsType, sp_id=:spId,  sp_class=:spClass, sp_message_id=:spMessageId,  biz_no=:bizNo, user_id=:userId, mobile=:mobile, content=:content, input_time=:inputTime,  sent_time=:sentTime,  version=:version,  page_charset=:pageCharset,  user_ip=:userIp,  device_id=:deviceId,  sms_status=:smsStatus, result=:result, ext_json=:extJson, sent_date=:sentDate, billing_count=:billingCount, callback_url=:callbackUrl, receive_time=:receiveTime, form=:form WHERE unique_number=:uniqueNumber";
        this.batchUpdate(sql, messages.toArray(new SmsMessage[messages.size()]));
    }

    public void updateSmsMessagesBySpMessageIdAndMobile(List<SmsMessage> messages) {
        Assert.notEmpty(messages, (String)"SmsMessage collection is empty!");
        String sql = "UPDATE sms_message SET sms_status=:smsStatus ,result=:result ,receive_time=:receiveTime WHERE sp_message_id=:spMessageId";
        this.batchUpdate(sql, messages.toArray(new SmsMessage[messages.size()]));
    }

    public List<SmsMessage> getSmsMessagesBySpMessageIdAndMobile(List<SmsMessage> messages) {
        Assert.notEmpty(messages, (String)"SmsMessage collection is empty!");
        String sql = "SELECT * FROM sms_message WHERE sp_message_id IN (:spMessageIds) ORDER BY sent_time";
        ArrayList spMessageIds = Lists.newArrayList();
        for (SmsMessage message : messages) {
            spMessageIds.add(message.getSpMessageId());
        }
        Map<String, ArrayList> params = Collections.singletonMap("spMessageIds", spMessageIds);
        List smsMessages = this.namedParameterJdbcTemplate.query(sql, params, (RowMapper)new BeanPropertyRowMapper(SmsMessage.class));
        return smsMessages;
    }

    public List<SmsMessage> getSmsMessagesBySpId(String spId) {
        Assert.notNull((Object)spId, (String)"spId could'nt be null!");
        List<Object[]> smsMessages = this.query("SELECT * FROM sms_message WHERE sp_id=? ORDER BY receive_time limit 10", new Object[]{spId});
        return smsMessages;
    }

    public SmsMessage getSmsMessageBySpMessageId(String spMessageId) {
        Assert.notNull((Object)spMessageId, (String)"spMessageId could'nt be null!");
        String sql = "SELECT * FROM sms_message WHERE spMessageId=?";
        return (SmsMessage)this.queryForObject(sql, new Object[]{spMessageId});
    }

    public List<SmsMessage> getSmsMessage(SmsMessage smsMessage, int limit, int offset) {
        Assert.notNull((Object)smsMessage, (String)"smsMessage  is empty!");
        StringBuffer sql = new StringBuffer("SELECT * FROM sms_message WHERE 1=1 ");
        HashMap params = Maps.newHashMap();
        if (!Strings.isNullOrEmpty((String)smsMessage.getUserId())) {
            params.put("userId", smsMessage.getUserId());
            sql.append("user_id=:userId ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getMobile())) {
            params.put("mobile", smsMessage.getMobile());
            sql.append("and ").append("mobile=:mobile ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getBizNo())) {
            params.put("biz_no", smsMessage.getBizNo());
            sql.append("and ").append("biz_no=:biz_no ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getSpId())) {
            params.put("sp_id", smsMessage.getSpId());
            sql.append("and ").append("sp_id=:sp_id ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getSpMessageId())) {
            params.put("sp_message_id", smsMessage.getSpMessageId());
            sql.append("and ").append("sp_message_id=:sp_message_id ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getSmsType())) {
            params.put("smsType", smsMessage.getSmsType());
            sql.append("and ").append("smsType=:smsType ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getForm())) {
            params.put("form", smsMessage.getForm());
            sql.append("and ").append("form=:form ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getSmsStatus())) {
            params.put("sms_status", smsMessage.getSmsStatus());
            sql.append("and ").append("sms_status=:sms_status ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getInputTime())) {
            String inputTime = smsMessage.getInputTime();
            String[] inputTimeArray = inputTime.split(",");
            String[] markArray = new String[]{">", "<="};
            int i = 0;
            while (i < inputTimeArray.length) {
                if (!Strings.isNullOrEmpty((String)inputTimeArray[i])) {
                    params.put("input_time" + i, inputTimeArray[i]);
                    sql.append("and ").append("input_time" + markArray[i] + ":input_time" + i).append(" ");
                }
                if (++i != markArray.length) continue;
            }
        }
        sql.append("order by input_time desc ");
        sql.append("limit " + limit).append(" ");
        sql.append("offset " + offset).append(" ");
        List smsMessages = this.namedParameterJdbcTemplate.query(sql.toString(), (Map)params, (RowMapper)new BeanPropertyRowMapper(SmsMessage.class));
        return smsMessages;
    }

    public long getSmsMtCount(SmsMessage smsMessage) {
        Number number;
        Assert.notNull((Object)smsMessage, (String)"smsMessage  is empty!");
        StringBuffer sql = new StringBuffer("SELECT count(*) FROM sms_message WHERE 1=1 ");
        HashMap params = Maps.newHashMap();
        if (!Strings.isNullOrEmpty((String)smsMessage.getUserId())) {
            params.put("userId", smsMessage.getUserId());
            sql.append("user_id=:userId ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getMobile())) {
            params.put("mobile", smsMessage.getMobile());
            sql.append("and ").append("mobile=:mobile ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getBizNo())) {
            params.put("biz_no", smsMessage.getBizNo());
            sql.append("and ").append("biz_no=:biz_no ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getSpId())) {
            params.put("sp_id", smsMessage.getSpId());
            sql.append("and ").append("sp_id=:sp_id ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getSpMessageId())) {
            params.put("sp_message_id", smsMessage.getSpMessageId());
            sql.append("and ").append("sp_message_id=:sp_message_id ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getSmsType())) {
            params.put("smsType", smsMessage.getSmsType());
            sql.append("and ").append("smsType=:smsType ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getForm())) {
            params.put("form", smsMessage.getForm());
            sql.append("and ").append("form=:form ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getSmsStatus())) {
            params.put("sms_status", smsMessage.getSmsStatus());
            sql.append("and ").append("sms_status=:sms_status ");
        }
        if (!Strings.isNullOrEmpty((String)smsMessage.getInputTime())) {
            String inputTime = smsMessage.getInputTime();
            String[] inputTimeArray = inputTime.split(",");
            String[] markArray = new String[]{">", "<="};
            int i = 0;
            while (i < inputTimeArray.length) {
                if (!Strings.isNullOrEmpty((String)inputTimeArray[i])) {
                    params.put("input_time" + i, inputTimeArray[i]);
                    sql.append("and ").append("input_time" + markArray[i] + ":input_time" + i).append(" ");
                }
                if (++i != markArray.length) continue;
            }
        }
        return (number = (Number)this.namedParameterJdbcTemplate.queryForObject(sql.toString(), (Map)params, Integer.class)) != null ? number.longValue() : 0L;
    }
}

