/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.service;

import com.google.common.base.Strings;
import com.xunlei.channel.sms.constants.SmsStatus;
import com.xunlei.channel.sms.dao.SmsMessageDao;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.util.DateUtils;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsMessageService {
    private static final Logger logger = LoggerFactory.getLogger(SmsMessageService.class);
    @Autowired
    private SmsMessageDao messageDao;

    public void saveSmsMessages(List<SmsMessage> smsMessages) {
        this.messageDao.saveSmsMessages(smsMessages);
    }

    public void saveSmsMessages(SmsMessageRequest ... messageRequests) {
        if (messageRequests == null) {
            return;
        }
        List<SmsMessage> smsMessages = this.convertMessageRequestToMessage(messageRequests);
        this.messageDao.saveSmsMessages(smsMessages);
    }

    public void setMessageDao(SmsMessageDao messageDao) {
        this.messageDao = messageDao;
    }

    public void updateMessageRequestStatus(SmsMessageRequest ... messageRequests) {
        if (messageRequests == null) {
            return;
        }
        List<SmsMessage> messages = this.convertMessageRequestToMessage(messageRequests);
        this.messageDao.updateSmsMessages(messages);
    }

    public void updateSmsMessagesBySpMessageIdAndMobile(List<SmsMessage> smsMessages) {
        if (smsMessages == null) {
            return;
        }
        this.messageDao.updateSmsMessagesBySpMessageIdAndMobile(smsMessages);
    }

    public List<SmsMessage> getSmsMessagesBySpMessageIdAndMobile(List<SmsMessage> smsMessages) {
        return this.messageDao.getSmsMessagesBySpMessageIdAndMobile(smsMessages);
    }

    public List<SmsMessage> getSmsMessagesBySpId(String spId) {
        return this.messageDao.getSmsMessagesBySpId(spId);
    }

    public List<SmsMessage> getSmsMessage(SmsMessage smsMessage, int limit, int offset) {
        return this.messageDao.getSmsMessage(smsMessage, limit, offset);
    }

    private List<SmsMessage> convertMessageRequestToMessage(SmsMessageRequest ... messageRequests) {
        ArrayList<SmsMessage> messages = new ArrayList<SmsMessage>();
        for (SmsMessageRequest messageRequest : messageRequests) {
            List<SmsMessage> smsMessages = this.processMessagesWithoutStatus(messageRequest);
            if (smsMessages == null) continue;
            messages.addAll(smsMessages);
        }
        return messages;
    }

    private List<SmsMessage> processMessages(SmsMessageRequest messageRequest) {
        SmsStatus smsStatus = messageRequest.getSmsStatus();
        String result = messageRequest.getResult();
        if (smsStatus == null) {
            logger.warn("No status found in MessageRequest: {}", (Object)messageRequest);
            return null;
        }
        List smsMessages = messageRequest.getSmsMessages();
        for (SmsMessage smsMessage : smsMessages) {
            if (smsStatus.equals((Object)SmsStatus.SUCCESS)) {
                smsMessage.setSentTime(DateUtils.getNowDateTime());
                smsMessage.setSentDate(DateUtils.getNowDate());
            }
            if (Strings.isNullOrEmpty((String)smsMessage.getResult())) {
                smsMessage.setResult(result);
            }
            smsMessage.setSmsStatus(smsStatus.getStatus());
        }
        return smsMessages;
    }

    private List<SmsMessage> processMessagesWithoutStatus(SmsMessageRequest messageRequest) {
        String result = messageRequest.getResult();
        List smsMessages = messageRequest.getSmsMessages();
        for (SmsMessage smsMessage : smsMessages) {
            if (SmsStatus.SUCCESS.getStatus().equals(smsMessage.getSmsStatus())) {
                smsMessage.setSentTime(DateUtils.getNowDateTime());
                smsMessage.setSentDate(DateUtils.getNowDate());
            }
            if (!Strings.isNullOrEmpty((String)smsMessage.getResult())) continue;
            smsMessage.setResult(result);
        }
        return smsMessages;
    }

    public void updateMessages(SmsMessageRequest ... messageRequests) {
        if (messageRequests == null) {
            return;
        }
        ArrayList<SmsMessage> messages = new ArrayList<SmsMessage>();
        for (SmsMessageRequest messageRequest : messageRequests) {
            List<SmsMessage> smsMessages = this.processMessages(messageRequest);
            if (smsMessages == null) continue;
            messages.addAll(smsMessages);
        }
        this.messageDao.updateSmsMessages(messages);
    }
}

