DROP TABLE IF EXISTS config_info;
DROP TABLE IF EXISTS sms_message;
DROP TABLE IF EXISTS sms_biz_info;
DROP TABLE IF EXISTS sms_sp_info;
DROP TABLE IF EXISTS sms_queue;
DROP TABLE IF EXISTS sms_biz_ip_info;
-- ENGINE[\w\W]+?;
-- COMMENT\s+\'.*\',

CREATE TABLE config_info (
  config_id    INTEGER PRIMARY KEY AUTOINCREMENT,
  config_group VARCHAR(100),
  config_name  VARCHAR(100),
  config_value VARCHAR(255),
  config_describe VARCHAR(255)
);
CREATE UNIQUE INDEX config_info_config_unique
  ON config_info (config_group, config_name);
CREATE INDEX config_info_config_name_index
  ON config_info (config_name);
CREATE INDEX config_info_config_group_index
  ON config_info (config_group);


CREATE TABLE sms_message (
  id            INTEGER PRIMARY KEY AUTOINCREMENT
  ,
  unique_number VARCHAR(255) NOT NULL
  ,
  sms_type      VARCHAR(32)  NOT NULL
  ,
  sp_id         VARCHAR(255) NOT NULL
  ,
  sp_class      VARCHAR(255) NOT NULL
  ,
  sp_message_id VARCHAR(255),
  biz_no        VARCHAR(128),
  mobile        VARCHAR(32),
  user_id       VARCHAR(255),
  content       VARCHAR(255) NOT NULL
  ,
  billing_count INTEGER DEFAULT 1,
  input_time    VARCHAR(64)  NOT NULL
  ,
  sent_time     VARCHAR(64),
  version       VARCHAR(32),
  page_charset  VARCHAR(16),
  user_ip       VARCHAR(128),
  device_id     VARCHAR(255),
  sms_status    VARCHAR(16),
  result        VARCHAR(255),
  ext_json      VARCHAR(255),
  sent_date     VARCHAR(10)
);
CREATE INDEX sms_message_mobile_index
  ON sms_message (mobile);
CREATE INDEX sms_message_user_id_index
  ON sms_message (user_id);
CREATE INDEX sms_message_sms_type_index
  ON sms_message (sms_type);
CREATE INDEX sms_message_sp_id_index
  ON sms_message (sp_id);
CREATE INDEX sms_message_sp_id_message_id_index
  ON sms_message (sp_id, sp_message_id);
CREATE INDEX sms_message_sp_class_index
  ON sms_message (sp_class);
CREATE INDEX sms_message_biz_no_index
  ON sms_message (biz_no);
CREATE INDEX sms_message_input_time_index
  ON sms_message (input_time);
CREATE INDEX sms_message_sent_time_index
  ON sms_message (sent_time);
CREATE INDEX sms_message_sms_status_index
  ON sms_message (sms_status);
CREATE UNIQUE INDEX sms_message_unique_number_index
  ON sms_message (unique_number);


CREATE TABLE sms_biz_info (
  id            INTEGER PRIMARY KEY AUTOINCREMENT,
  biz_no        VARCHAR(20)  NOT NULL
  ,
  biz_name      VARCHAR(30)  NOT NULL
  ,
  biz_key       VARCHAR(20)  NOT NULL
  ,
  contact_name  VARCHAR(255)
  ,
  biz_status    VARCHAR(2),
  contact_phone VARCHAR(255)
  ,
  contact_email VARCHAR(255)
  ,
  input_by      VARCHAR(30),
  input_time    VARCHAR(19),
  edit_by       VARCHAR(30),
  edit_time     VARCHAR(19),
  remark        VARCHAR(30),
  queue_id      VARCHAR(255) NOT NULL
  ,
  mo_url        VARCHAR(255)
);
CREATE UNIQUE INDEX sms_biz_info_biz_no_index
  ON sms_biz_info (biz_no);
CREATE INDEX sms_biz_info_biz_name_index
  ON sms_biz_info (biz_name);
CREATE INDEX sms_biz_info_input_time_index
  ON sms_biz_info (input_time);

CREATE TABLE sms_biz_ip_info (
  id INTEGER  PRIMARY KEY AUTOINCREMENT ,
  biz_no VARCHAR(20) NOT NULL,
  ip_config VARCHAR(18) NOT NULL,
  ip_describe VARCHAR(255)
);
CREATE INDEX sms_biz_ip_biz_no_index ON sms_biz_ip_info(biz_no);

CREATE TABLE sms_queue (
  id         INTEGER PRIMARY KEY AUTOINCREMENT,
  queue_id   VARCHAR(255) NOT NULL
  ,
  queue_name VARCHAR(255),
  sp_id      VARCHAR(32)  NOT NULL
  ,
  priority   INT
);
CREATE UNIQUE INDEX sms_queue_queue_id_sp_uniq
  ON sms_queue (queue_id, sp_id);
CREATE INDEX sms_queue_queue_id
  ON sms_queue (queue_id);


CREATE TABLE sms_sp_info (
  sp_id            VARCHAR(32)  NOT NULL
  ,
  sp_name          VARCHAR(128) NOT NULL
  ,
  sp_class         VARCHAR(255) NOT NULL
  ,
  sms_type         VARCHAR(255) NOT NULL
  ,
  account          VARCHAR(255),
  password         VARCHAR(255),
  api_url          VARCHAR(255),
  mt_count         BIGINT                DEFAULT 0
  ,
  support_carriers VARCHAR(255) NOT NULL
  ,
  ext1             VARCHAR(255),
  ext2             VARCHAR(255),
  ext3             VARCHAR(255),
  ext_json         VARCHAR(255),
  available        BOOLEAN      NOT NULL DEFAULT 1
);
CREATE UNIQUE INDEX sms_biz_info_sp_id_index
  ON sms_sp_info (sp_id);
