/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.dao;

import com.xunlei.channel.sms.dao.BaseDao;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository
public class SmsMessageDao
extends BaseDao<SmsMessage> {
    public void saveSmsMessages(List<SmsMessage> messages) {
        Assert.notEmpty(messages, (String)"SmsMessage collection is empty!");
        String sql = "INSERT INTO sms_message(unique_number, sms_type, sp_id, sp_class, sp_message_id, biz_no,  user_id, mobile, content, input_time, sent_time, version, page_charset, user_ip, device_id, sms_status, result, ext_json, sent_date, billing_count) values (:uniqueNumber, :smsType, :spId, :spClass, :spMessageId, :bizNo, :userId, :mobile, :content, :inputTime, :sentTime, :version, :pageCharset, :userIp, :deviceId, :smsStatus, :result, :extJson, :sentDate, :billingCount)";
        this.batchUpdate(sql, messages.toArray(new SmsMessage[messages.size()]));
    }

    public void updateMessageStatusAndResultByUniqueNumber(List<SmsMessage> messages) {
        Assert.notEmpty(messages, (String)"SmsMessage collection is empty!");
        String sql = "UPDATE sms_message SET sms_status=:smsStatus, result=:result WHERE unique_number=:uniqueNumber";
        this.batchUpdate(sql, messages.toArray(new SmsMessage[messages.size()]));
    }

    public void updateSmsMessages(List<SmsMessage> messages) {
        Assert.notEmpty(messages, (String)"SmsMessage collection is empty!");
        String sql = "UPDATE sms_message SET  sms_type=:smsType, sp_id=:spId,  sp_class=:spClass, sp_message_id=:spMessageId,  biz_no=:bizNo, user_id=:userId, mobile=:mobile, content=:content, input_time=:inputTime,  sent_time=:sentTime,  version=:version,  page_charset=:pageCharset,  user_ip=:userIp,  device_id=:deviceId,  sms_status=:smsStatus, result=:result, ext_json=:extJson, sent_date=:sentDate, billing_count=:billingCount WHERE unique_number=:uniqueNumber";
        this.batchUpdate(sql, messages.toArray(new SmsMessage[messages.size()]));
    }
}

