/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.support.verifycode;

import com.xunlei.channel.sms.cache.redis.RedisTemplateCacheService;
import com.xunlei.channel.sms.cache.vo.Cache;
import com.xunlei.channel.sms.entity.BizInfo;
import com.xunlei.channel.sms.entity.MobileVerifyRequest;
import com.xunlei.channel.sms.entity.ReturnResult;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import com.xunlei.channel.sms.service.BizInfoService;
import com.xunlei.channel.sms.support.SmsMessageSupporter;
import com.xunlei.channel.sms.support.verifycode.SmsMessageVerifyCodeConfig;
import com.xunlei.channel.sms.util.random.RandomUtils;
import com.xunlei.channel.sms.util.reflect.ReflectionUtils;
import com.xunlei.channel.sms.util.sign.SignUtils;
import com.xunlei.pay.proxy.dto.request.GetUserPhoneById;
import com.xunlei.pay.proxy.dto.response.UserPhoneResponse;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SmsMessageVerifyCodeSupporter
implements SmsMessageSupporter {
    private static final Logger logger = LoggerFactory.getLogger(SmsMessageVerifyCodeSupporter.class);
    private static final int ONLY_NUMBER = 1;
    private static final int DEFAULT_CODE_LENGTH = 6;
    private Pattern bracePattern = Pattern.compile("\\{}");
    private static final String VERIFY_CODE_CACHE_PREFIX = "verify_code:";
    private static final String BIZ_NO_AND_MOBILE_DELIMITER = ":";
    public static final String CODE_CACHE_KEY_NAME = "code";
    public static final String VERIFY_TIMES_CACHE_KEY_NAME = "verify_times";
    public static final String MAX_VERIFY_TIMES_CACHE_KEY_NAME = "max_verify_times";
    public static final int DEFAULT_MAX_VERIFY_TIMES = 5;
    @Autowired
    private SmsMessageVerifyCodeConfig verifyCodeConfig;
    @Autowired
    private RedisTemplateCacheService redisTemplateCacheService;
    @Autowired
    private BizInfoService bizInfoService;
    private RandomUtils.RandomStringUtils randomStringUtils = RandomUtils.newRandomStringUtils((boolean)true);

    @Override
    public void process(SmsMessageRequest messageRequest) throws Exception {
        if (messageRequest == null) {
            return;
        }
        String content = messageRequest.getContent();
        if (content == null) {
            return;
        }
        Boolean needCode = messageRequest.getNeedCode();
        if (needCode == null || !needCode.booleanValue()) {
            return;
        }
        Matcher matcher = this.bracePattern.matcher(content);
        if (!matcher.find()) {
            return;
        }
        String code = this.generateCode(messageRequest);
        String finalContent = matcher.replaceAll(code);
        if (logger.isDebugEnabled()) {
            logger.debug("Replace content: {} with: {}", (Object)content, (Object)finalContent);
        }
        messageRequest.setContent(finalContent);
        messageRequest.setCode(code);
        this.setCode(messageRequest);
        this.setMaxVerifyTimes(messageRequest);
    }

    public ReturnResult verify(MobileVerifyRequest verify) {
        boolean b = this.checkSign(verify);
        if (!b) {
            return ReturnResult.CHECK_SIGN_ERROR;
        }
        String mobile = verify.getMobile();
        if (StringUtils.isEmpty((Object)mobile)) {
            String userId = verify.getUserId();
            if (StringUtils.isEmpty((Object)userId)) {
                return InterceptResult.VERIFY_MOBILE_OR_USER_ID_EMPTY;
            }
            String userPhone = this.getUserPhoneNumber(userId);
            logger.info("Found mobile: {} by uid: {}", (Object)userPhone, (Object)userId);
            if (userPhone == null) {
                return InterceptResult.INTERCEPTOR_NOT_FOUND_MOBILE_BY_UID;
            }
            verify.setMobile(userPhone);
        }
        return this.verifyCode(verify);
    }

    private String getUserPhoneNumber(String userId) {
        try {
            GetUserPhoneById userPhoneRequest = new GetUserPhoneById(userId);
            UserPhoneResponse response = (UserPhoneResponse)userPhoneRequest.request();
            return response.getPhone();
        }
        catch (Exception e) {
            logger.error("Error happened when getting phone by userId: " + userId + ", message: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean checkSign(MobileVerifyRequest verify) {
        Map map = ReflectionUtils.convertObjectFieldsToMap((Object)verify);
        BizInfo bizInfo = this.bizInfoService.getBizInfoByBizNo(verify.getBizNo());
        String bizKey = bizInfo.getBizKey();
        HashSet<String> unsignedKeys = new HashSet<String>();
        unsignedKeys.add("signMsg");
        return SignUtils.checkSign((String)verify.getSignMsg(), (Map)map, unsignedKeys, (String)bizKey);
    }

    public ReturnResult verifyCode(MobileVerifyRequest verify) {
        String bizNo = verify.getBizNo();
        String mobile = verify.getMobile();
        String verifyCode = verify.getVerifyCode();
        String cacheGroup = this.getCacheGroup(bizNo, mobile);
        RedisTemplateCacheService cacheService = this.redisTemplateCacheService;
        try {
            String verifyCodeCache = cacheService.getCacheValue(cacheGroup, CODE_CACHE_KEY_NAME);
            if (verifyCodeCache == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Verify code in cache is null, so return expire. request: {}", (Object)verify);
                }
                return ReturnResult.VERIFY_CODE_EXPIRED;
            }
            if (verifyCode != null && verifyCode.equalsIgnoreCase(verifyCodeCache)) {
                cacheService.clearCachesByGroup(cacheGroup);
                return ReturnResult.SUCCESS;
            }
            this.increaseVerifyFailedTimes(verify);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return ReturnResult.SYSTEM_ERROR;
        }
        return ReturnResult.VERIFY_CODE_ERROR;
    }

    private void increaseVerifyFailedTimes(MobileVerifyRequest verify) {
        String bizNo = verify.getBizNo();
        String mobile = verify.getMobile();
        String cacheGroup = this.getCacheGroup(bizNo, mobile);
        RedisTemplateCacheService cacheService = this.redisTemplateCacheService;
        try {
            int verifyTimes;
            if (this.isOnceFlag(verify)) {
                cacheService.clearCachesByGroup(cacheGroup);
                if (logger.isDebugEnabled()) {
                    logger.debug("Succeed clear cache: {} with verify code oneceFlag.", (Object)cacheGroup);
                }
                return;
            }
            String verifyTimesCache = cacheService.getCacheValue(cacheGroup, VERIFY_TIMES_CACHE_KEY_NAME);
            String maxVerifyTimesCache = cacheService.getCacheValue(cacheGroup, MAX_VERIFY_TIMES_CACHE_KEY_NAME);
            if (verifyTimesCache == null) {
                cacheService.setCache(new Cache(cacheGroup, VERIFY_TIMES_CACHE_KEY_NAME, "1"));
                return;
            }
            int maxVerifyTimes = 5;
            if (maxVerifyTimesCache != null) {
                maxVerifyTimes = Integer.valueOf(maxVerifyTimesCache);
            }
            if ((verifyTimes = Integer.valueOf(verifyTimesCache) + 1) >= maxVerifyTimes) {
                logger.info("VerifyTimes: {} exceed maxVerifyTimes: {}, so delete code cache: {}", new Object[]{verifyTimes, maxVerifyTimes, cacheGroup});
                cacheService.clearCachesByGroup(cacheGroup);
            } else {
                cacheService.setCache(new Cache(cacheGroup, VERIFY_TIMES_CACHE_KEY_NAME, verifyTimes + ""));
                if (logger.isDebugEnabled()) {
                    logger.debug("Succeed set verifyTimes: {} to cache: {}", (Object)verifyTimes, (Object)cacheGroup);
                }
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    private void setCode(SmsMessageRequest messageRequest) throws Exception {
        String code = messageRequest.getCode();
        String mobile = messageRequest.getMobile();
        String cacheGroup = this.getCacheGroup(messageRequest.getBizNo(), mobile);
        Cache cache = new Cache(cacheGroup, CODE_CACHE_KEY_NAME, code);
        this.setCache(messageRequest, cache);
    }

    private void setMaxVerifyTimes(SmsMessageRequest messageRequest) throws Exception {
        Integer maxVerifyTimes = messageRequest.getMaxVerifyTimes();
        if (maxVerifyTimes == null) {
            maxVerifyTimes = 5;
        }
        String mobile = messageRequest.getMobile();
        String cacheGroup = this.getCacheGroup(messageRequest.getBizNo(), mobile);
        Cache cache = new Cache(cacheGroup, MAX_VERIFY_TIMES_CACHE_KEY_NAME, maxVerifyTimes + "");
        if (logger.isDebugEnabled()) {
            logger.debug("Setting max verifyTimes: {} to group: {}", (Object)cache.getCacheValue(), (Object)cacheGroup);
        }
        this.setCache(messageRequest, cache);
    }

    private void setCache(SmsMessageRequest messageRequest, Cache cache) throws Exception {
        RedisTemplateCacheService cacheService = this.redisTemplateCacheService;
        cacheService.setCache(cache);
        cacheService.setExpire(cache.getCacheGroup(), (long)this.getVerifyCodeTimeOut(messageRequest), TimeUnit.SECONDS);
    }

    private int getVerifyCodeTimeOut(SmsMessageRequest messageRequest) {
        Integer expireSeconds;
        if (messageRequest == null || (expireSeconds = messageRequest.getExpireSeconds()) == null || expireSeconds == 0) {
            return this.verifyCodeConfig.getVerifyCodeTimeOut();
        }
        return expireSeconds;
    }

    protected String getCacheGroup(String bizNo, String mobile) {
        return VERIFY_CODE_CACHE_PREFIX + bizNo + BIZ_NO_AND_MOBILE_DELIMITER + mobile;
    }

    private boolean isOnceFlag(MobileVerifyRequest verifyRequest) {
        return verifyRequest.getOnceFlag() != null && verifyRequest.getOnceFlag() != false;
    }

    private String generateCode(SmsMessageRequest messageRequest) {
        Integer codeLen = messageRequest.getCodeLen();
        if (codeLen == null) {
            codeLen = 6;
        }
        String code = this.isOnlyNumber(messageRequest) ? this.randomStringUtils.randomNumberString(codeLen.intValue()) : this.randomStringUtils.randomWordString(codeLen.intValue());
        return code;
    }

    private boolean isOnlyNumber(SmsMessageRequest messageRequest) {
        Integer onlyNum = messageRequest.getOnlyNum();
        if (onlyNum == null) {
            return true;
        }
        return 1 == onlyNum;
    }
}

