/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.persistent;

import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.queue.QueueElement;
import com.xunlei.channel.sms.queue.kafka.KafkaQueue;
import com.xunlei.channel.sms.threadpool.Producer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentSmsMessageProducer
implements Producer<List<SmsMessageRequest>> {
    private static final Logger logger = LoggerFactory.getLogger(PersistentSmsMessageProducer.class);
    private KafkaQueue<SmsMessageRequest> queue;

    public PersistentSmsMessageProducer(KafkaQueue<SmsMessageRequest> queue) {
        this.queue = queue;
    }

    public List<SmsMessageRequest> produce() {
        try {
            List<SmsMessageRequest> smsMessageRequests = this.pullMessages(true);
            logger.info("Pulled data from persistent queue: {}", smsMessageRequests);
            return smsMessageRequests;
        }
        catch (Exception e) {
            logger.error("Error when pull from persistent queue! message: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<SmsMessageRequest> pullMessages(boolean blocking) {
        ArrayList<SmsMessageRequest> messages = new ArrayList<SmsMessageRequest>();
        List queueElements = this.queue.pull(blocking);
        this.addQueueElementsToMessages(queueElements, messages);
        return messages;
    }

    private void addQueueElementsToMessages(List<QueueElement<SmsMessageRequest>> queueElements, List<SmsMessageRequest> messages) {
        if (queueElements == null || messages == null) {
            return;
        }
        for (QueueElement<SmsMessageRequest> queueElement : queueElements) {
            SmsMessageRequest data = (SmsMessageRequest)queueElement.getData();
            if (logger.isDebugEnabled()) {
                logger.debug("Got data: {} from queue: {}", (Object)data, this.queue);
            }
            messages.add(data);
        }
    }
}

