/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.persistent;

import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.service.SmsMessageService;
import com.xunlei.channel.sms.threadpool.Consumer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class PersistentSmsMessageConsumer
implements Consumer<List<SmsMessageRequest>> {
    private static final Logger logger = LoggerFactory.getLogger(PersistentSmsMessageConsumer.class);
    @Autowired
    private SmsMessageService messageService;

    public void consumer(List<SmsMessageRequest> messageRequests) {
        if (CollectionUtils.isEmpty(messageRequests)) {
            logger.warn("No data found by persistent consumer!");
            return;
        }
        try {
            this.messageService.saveSmsMessages(messageRequests.toArray(new SmsMessageRequest[0]));
            logger.info("Succeed save data to db: {}", messageRequests);
        }
        catch (Exception e) {
            logger.error("Failed save data to db: " + messageRequests + " error message: " + e.getMessage(), (Throwable)e);
        }
    }
}

