/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.mt;

import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.queue.Queue;
import com.xunlei.channel.sms.queue.QueueElement;
import com.xunlei.channel.sms.threadpool.Producer;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsMessageProducer
implements Producer<List<SmsMessageRequest>> {
    private static final Logger logger = LoggerFactory.getLogger(SmsMessageProducer.class);
    private int maxPullSize = 200;
    private Queue<SmsMessageRequest> queue;
    private long pullTimeout = 1000L;

    public SmsMessageProducer(Queue<SmsMessageRequest> queue) {
        this.queue = queue;
    }

    public List<SmsMessageRequest> produce() {
        LinkedList<SmsMessageRequest> messages = new LinkedList<SmsMessageRequest>();
        try {
            long endTime = this.getEndTime();
            boolean hasData = this.pullAndAddToMessages(messages, true);
            if (logger.isDebugEnabled()) {
                logger.debug("Succeed blocking got queue data: {}", messages);
            }
            while (hasData && messages.size() < this.maxPullSize && this.isAlive(endTime)) {
                hasData = this.pullAndAddToMessages(messages, false);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Succeed unblocking got queue data? {}", (Object)hasData);
            }
            return messages;
        }
        catch (Exception e) {
            logger.error("Caught exception when pulling data from queue: " + this.queue + " error message: " + e.getMessage(), (Throwable)e);
            return messages;
        }
    }

    private boolean isAlive(long endTime) {
        return System.currentTimeMillis() <= endTime;
    }

    private long getEndTime() {
        long end = System.currentTimeMillis() + this.pullTimeout;
        return end;
    }

    public boolean pullAndAddToMessages(List<SmsMessageRequest> messages, boolean blocking) {
        List queueElements = this.queue.pull(blocking);
        this.addQueueElementsToMessages(queueElements, messages);
        return queueElements != null && queueElements.size() > 0;
    }

    private void addQueueElementsToMessages(List<QueueElement<SmsMessageRequest>> queueElements, List<SmsMessageRequest> messages) {
        if (queueElements == null || messages == null) {
            return;
        }
        for (QueueElement<SmsMessageRequest> queueElement : queueElements) {
            SmsMessageRequest data = (SmsMessageRequest)queueElement.getData();
            if (logger.isDebugEnabled()) {
                logger.debug("Got data: {} from queue: {}", (Object)data, this.queue);
            }
            messages.add(data);
        }
    }

    public int getMaxPullSize() {
        return this.maxPullSize;
    }

    public void setMaxPullSize(int maxPullSize) {
        this.maxPullSize = maxPullSize;
    }

    public void setPullTimeout(long pullTimeout) {
        this.pullTimeout = pullTimeout;
    }

    public long getPullTimeout() {
        return this.pullTimeout;
    }
}

