/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.core.impl;

import com.xunlei.channel.sms.constants.SmsStatus;
import com.xunlei.channel.sms.constants.SmsType;
import com.xunlei.channel.sms.core.SmsMessageHandler;
import com.xunlei.channel.sms.core.SmsMessageQueueElement;
import com.xunlei.channel.sms.entity.ReturnResult;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.entity.SmsResponseWithResponseInfo;
import com.xunlei.channel.sms.event.manager.SmsMessageEventManager;
import com.xunlei.channel.sms.health.exception.ExceptionHealthEvent;
import com.xunlei.channel.sms.health.exception.ExceptionReporter;
import com.xunlei.channel.sms.health.exception.ExceptionType;
import com.xunlei.channel.sms.interceptor.manager.SmsMessageInterceptorManager;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import com.xunlei.channel.sms.queue.Queue;
import com.xunlei.channel.sms.queue.QueueElement;
import com.xunlei.channel.sms.service.SmsMessageService;
import com.xunlei.channel.sms.support.MessageRequestConvertUtil;
import com.xunlei.channel.sms.support.SmsMessageSupporterManager;
import com.xunlei.channel.sms.util.DateUtils;
import com.xunlei.channel.sms.util.SequenceGenerator;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SmsMessageHandlerImpl
implements SmsMessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(SmsMessageHandlerImpl.class);
    protected SmsMessageInterceptorManager messageInterceptorManager;
    protected SmsMessageEventManager messageEventManager;
    protected Map<SmsType, Queue<SmsMessageRequest>> queueMap;
    @Autowired
    protected SmsMessageService messageService;
    @Autowired
    protected SmsMessageSupporterManager supporterManager;

    public SmsMessageHandlerImpl(SmsMessageInterceptorManager messageInterceptorManager, SmsMessageEventManager messageEventManager, Map<SmsType, Queue<SmsMessageRequest>> queueMap) {
        this.messageInterceptorManager = messageInterceptorManager;
        this.messageEventManager = messageEventManager;
        this.queueMap = queueMap;
    }

    @Override
    public ReturnResult handleRequest(SmsMessageRequest message, boolean persistent) {
        if (logger.isInfoEnabled()) {
            logger.info("Receive message: {}", (Object)message);
        }
        try {
            this.messageEventManager.receivedSmsMessage(message);
            ReturnResult returnResult = this.preHandleRequest(message);
            if (returnResult != null && !returnResult.isSuccess()) {
                logger.info("Returns non success result of pre handling. result: {}, message: {}", (Object)returnResult, (Object)message);
                return returnResult;
            }
            InterceptResult interceptResult = this.messageInterceptorManager.intercept(message);
            if (!ReturnResult.isSuccess((ReturnResult)interceptResult)) {
                logger.info("Intercepted message: {} with result: {}.", (Object)message, (Object)interceptResult);
                this.messageEventManager.rejectedSmsMessage(message, (ReturnResult)interceptResult);
                return interceptResult;
            }
            this.messageEventManager.acceptedSmsMessage(message);
            this.supporterManager.process(message);
            try {
                this.processMessageRequest(message, persistent);
            }
            catch (Exception e) {
                logger.error("Error when save message to db, message: " + e.getMessage(), (Throwable)e);
                ExceptionReporter.reportHealthEvent((ExceptionHealthEvent)ExceptionHealthEvent.newHealthEvent((ExceptionType)ExceptionType.SAVE_TO_DB_ERROR));
            }
            ReturnResult resultCode = this.pushToQueue(message);
            if (logger.isInfoEnabled()) {
                logger.info("Push message: {} to queue success.", (Object)message);
            }
            if (!ReturnResult.isSuccess((ReturnResult)resultCode)) {
                return resultCode;
            }
            String uniqueNumber = message.getUniqueNumber();
            if (StringUtils.hasText((String)uniqueNumber)) {
                return SmsResponseWithResponseInfo.newSuccessResponse((String)uniqueNumber);
            }
            return resultCode;
        }
        catch (Exception e) {
            logger.error("Caught exception when send message: " + message, (Throwable)e);
            return ReturnResult.SYSTEM_ERROR;
        }
    }

    @Override
    public boolean handleResult(SmsMessageRequest ... messageRequests) {
        this.messageService.updateMessageRequestStatus(messageRequests);
        for (SmsMessageRequest messageRequest : messageRequests) {
            SmsStatus smsStatus = messageRequest.getSmsStatus();
            if (smsStatus != SmsStatus.SUCCESS) continue;
            this.messageEventManager.sentSmsMessage(messageRequest);
        }
        return true;
    }

    protected ReturnResult preHandleRequest(SmsMessageRequest message) {
        return ReturnResult.SUCCESS;
    }

    protected void processMessageRequest(SmsMessageRequest message, boolean saveToDb) {
        String nowDateTime = DateUtils.getNowDateTime();
        message.setInputTime(nowDateTime);
        List smsMessages = MessageRequestConvertUtil.convertMessageRequestToSmsMessage((SmsMessageRequest)message);
        message.setBatchSend(Boolean.valueOf(smsMessages.size() > 1));
        String sequenceId = SequenceGenerator.generateSequence();
        if (message.getBatchSend().booleanValue()) {
            for (SmsMessage smsMessage : smsMessages) {
                smsMessage.setUniqueNumber(SequenceGenerator.generateSequence());
                smsMessage.setBatchId(sequenceId);
            }
        } else {
            for (SmsMessage smsMessage : smsMessages) {
                smsMessage.setUniqueNumber(sequenceId);
                smsMessage.setBatchId(sequenceId);
            }
        }
        message.setUniqueNumber(sequenceId);
        message.setSmsMessages(smsMessages);
        if (saveToDb) {
            this.messageService.saveSmsMessages(smsMessages);
        }
    }

    protected ReturnResult pushToQueue(SmsMessageRequest message) {
        SmsMessageQueueElement element = new SmsMessageQueueElement(message);
        Queue<SmsMessageRequest> queue = this.getQueue(message);
        Assert.notNull(queue, (String)("Not found corresponding queue for sms type: " + message.getSmsType()));
        try {
            boolean push = this.pushToQueue(queue, element);
            if (push) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Push element: {} to queue success!", (Object)element);
                }
                return ReturnResult.SUCCESS;
            }
            logger.error("Push element: {} to queue failed!", (Object)element);
            return ReturnResult.SYSTEM_ERROR;
        }
        catch (Exception e) {
            logger.error("Push element: " + element + " to queue failed! error message: " + e.getMessage(), (Throwable)e);
            return ReturnResult.SYSTEM_ERROR;
        }
    }

    protected boolean pushToQueue(Queue<SmsMessageRequest> queue, SmsMessageQueueElement element) {
        return queue.push((QueueElement)element);
    }

    private Queue<SmsMessageRequest> getQueue(SmsMessageRequest message) {
        Queue<SmsMessageRequest> smsMessageQueue = this.queueMap.get(message.getSmsType());
        if (smsMessageQueue == null) {
            logger.error("Getting queue error, message: {} returns null queue...", (Object)message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got queue: {} by message: {}", smsMessageQueue, (Object)message);
        }
        return smsMessageQueue;
    }
}

