/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.core.concurrent;

import com.xunlei.channel.sms.constants.SmsType;
import com.xunlei.channel.sms.core.SmsMessageQueueElement;
import com.xunlei.channel.sms.core.impl.SmsMessageHandlerImpl;
import com.xunlei.channel.sms.entity.ReturnResult;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.event.manager.SmsMessageEventManager;
import com.xunlei.channel.sms.interceptor.manager.SmsMessageInterceptorManager;
import com.xunlei.channel.sms.queue.Queue;
import com.xunlei.channel.sms.queue.QueueElement;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighConcurrentSmsMessageHandler
extends SmsMessageHandlerImpl {
    private static final Logger logger = LoggerFactory.getLogger(HighConcurrentSmsMessageHandler.class);
    private Queue<SmsMessageRequest> messageRequestPersistentQueue;

    public HighConcurrentSmsMessageHandler(SmsMessageInterceptorManager messageInterceptorManager, SmsMessageEventManager messageEventManager, Map<SmsType, Queue<SmsMessageRequest>> queueMap, Queue<SmsMessageRequest> messageRequestPersistentQueue) {
        super(messageInterceptorManager, messageEventManager, queueMap);
        this.messageRequestPersistentQueue = messageRequestPersistentQueue;
    }

    @Override
    public ReturnResult handleRequest(SmsMessageRequest message, boolean persistent) {
        return super.handleRequest(message, false);
    }

    @Override
    protected boolean pushToQueue(Queue<SmsMessageRequest> queue, SmsMessageQueueElement element) {
        return queue.asynchronousPush((QueueElement)element);
    }

    @Override
    public boolean handleResult(SmsMessageRequest ... message) {
        boolean success = true;
        for (SmsMessageRequest smsMessageRequest : message) {
            SmsMessageQueueElement element = new SmsMessageQueueElement(smsMessageRequest);
            boolean pushSuccess = this.messageRequestPersistentQueue.asynchronousPush((QueueElement)element);
            if (pushSuccess) {
                logger.info("Succeed push message to persistent queue, message: {}", (Object)smsMessageRequest);
            } else {
                logger.error("Failed push message to persistent queue, message: {}", (Object)smsMessageRequest);
            }
            success &= pushSuccess;
        }
        return success;
    }
}

