/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.core;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.xunlei.channel.sms.constants.SmsStatus;
import com.xunlei.channel.sms.core.SmsMessageHandler;
import com.xunlei.channel.sms.entity.MtResult;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.mt.MtStatusCallback;
import com.xunlei.channel.sms.util.DateUtils;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MtStatusCallbackHandler
implements MtStatusCallback {
    private static final Logger logger = LoggerFactory.getLogger(MtStatusCallbackHandler.class);
    private SmsMessageHandler messageHandler;

    public MtStatusCallbackHandler(SmsMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void statusUpdated(SmsMessageRequest message, SmsStatus status) {
        if (message == null || status == null) {
            return;
        }
        message.setSmsStatus(status);
        boolean b = this.messageHandler.handleResult(message);
        if (!b) {
            logger.warn("Failed to process message status! message: {}", (Object)message);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Succeed update status, message: {}", (Object)message);
        }
    }

    public void statusUpdated(Map<SmsMessageRequest, List<MtResult>> messagesAndStatusMap) {
        if (CollectionUtils.isEmpty(messagesAndStatusMap)) {
            return;
        }
        for (Map.Entry<SmsMessageRequest, List<MtResult>> smsMessageRequestSmsStatusEntry : messagesAndStatusMap.entrySet()) {
            SmsMessageRequest messageRequest = smsMessageRequestSmsStatusEntry.getKey();
            this.processMessageRequestStatusAndSpMessageId(messageRequest, smsMessageRequestSmsStatusEntry.getValue());
            this.processMessageRequestStatus(messageRequest);
        }
        Set<SmsMessageRequest> smsMessageRequests = messagesAndStatusMap.keySet();
        Object[] smsMessageRequestArray = smsMessageRequests.toArray(new SmsMessageRequest[smsMessageRequests.size()]);
        boolean b = this.messageHandler.handleResult((SmsMessageRequest[])smsMessageRequestArray);
        if (!b) {
            logger.warn("Failed to process message status! messages: {}", (Object)Arrays.toString(smsMessageRequestArray));
        } else if (logger.isDebugEnabled()) {
            logger.debug("Succeed update status, messages: {}", (Object)Arrays.toString(smsMessageRequestArray));
        }
    }

    public void statusUpdated(List<MtResult> mtResults) {
    }

    private void processMessageRequestStatusAndSpMessageId(SmsMessageRequest smsMessageRequest, List<MtResult> mtResults) {
        String uniqueNumber;
        smsMessageRequest.setSmsStatus(SmsStatus.SUCCESS);
        List smsMessages = smsMessageRequest.getSmsMessages();
        HashMap mtResultMap = Maps.newHashMap();
        for (MtResult mtResult : mtResults) {
            uniqueNumber = mtResult.getUniqueNumber();
            if (Strings.isNullOrEmpty((String)uniqueNumber)) continue;
            mtResultMap.put(uniqueNumber, mtResult);
        }
        for (SmsMessage smsMessage : smsMessages) {
            uniqueNumber = smsMessage.getUniqueNumber();
            MtResult mtResult = (MtResult)mtResultMap.get(uniqueNumber);
            if (mtResult == null) continue;
            if (SmsStatus.FAIL.equals((Object)mtResult.getSmsStatus())) {
                smsMessageRequest.setSmsStatus(SmsStatus.FAIL);
            }
            smsMessage.setSmsStatus(mtResult.getSmsStatus().getStatus());
            smsMessage.setSpMessageId(mtResult.getSpMessageId());
        }
    }

    private void processMessageRequestStatus(SmsMessageRequest messageRequest) {
        for (SmsMessage smsMessage : messageRequest.getSmsMessages()) {
            smsMessage.setSentTime(DateUtils.getNowDateTime());
            smsMessage.setSentDate(DateUtils.getNowDate());
        }
    }
}

