/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.config.aop;

import com.xunlei.channel.sms.cache.CacheService;
import com.xunlei.channel.sms.cache.vo.Cache;
import com.xunlei.channel.sms.config.ConfigReloadable;
import com.xunlei.channel.sms.util.JacksonHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCollectionTypeCacheInterceptor<T>
implements ConfigReloadable {
    private static final Logger logger = LoggerFactory.getLogger(ServiceCollectionTypeCacheInterceptor.class);
    private CacheService cacheService;
    private final String cacheGroup;
    private final Class<T> rawType;

    public ServiceCollectionTypeCacheInterceptor(Class<T> rawType, String cacheGroup) {
        this.rawType = rawType;
        this.cacheGroup = cacheGroup;
    }

    public Collection<T> getCacheById(ProceedingJoinPoint call, String id) throws Throwable {
        Object proceed;
        String cacheValue = null;
        try {
            cacheValue = this.cacheService.getCacheValue(this.cacheGroup, id);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        if (cacheValue != null) {
            try {
                List found = JacksonHelper.convertJsonToListByRawType((String)cacheValue, this.rawType);
                if (logger.isDebugEnabled()) {
                    logger.debug("Got cache: {}", (Object)found);
                }
                if (found != null) {
                    return found;
                }
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
        if ((proceed = call.proceed()) != null) {
            try {
                String jsonString = JacksonHelper.getJsonString((Object)proceed);
                this.cacheService.setCache(new Cache(this.cacheGroup, id, jsonString));
                if (logger.isInfoEnabled()) {
                    logger.info("Setting configs: {} to cache.", proceed);
                }
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
            return (Collection)proceed;
        }
        return null;
    }

    public CacheService getCacheService() {
        return this.cacheService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Override
    public boolean reloadConfig() {
        try {
            this.cacheService.clearCachesByGroup(this.cacheGroup);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return false;
        }
        return true;
    }
}

