/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.cache.redis;

import com.xunlei.channel.sms.cache.CacheException;
import com.xunlei.channel.sms.cache.CacheService;
import com.xunlei.channel.sms.cache.vo.Cache;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class RedisTemplateCacheService
implements CacheService {
    private static final Logger logger = LoggerFactory.getLogger(RedisTemplateCacheService.class);
    private RedisTemplate<String, String> redisTemplate;

    public RedisTemplateCacheService(RedisTemplate<String, String> redisTemplate) {
        logger.info("Using RedisTemplate: {}", redisTemplate);
        this.redisTemplate = redisTemplate;
    }

    private BoundHashOperations<String, String, String> getOps(String cacheGroup) {
        BoundHashOperations hashOps = this.redisTemplate.boundHashOps((Object)cacheGroup);
        return hashOps;
    }

    @Override
    public Collection<String> keys(String pattern) throws CacheException {
        return this.redisTemplate.keys((Object)pattern);
    }

    @Override
    public boolean existsCache(String cacheGroup, String cacheName) throws CacheException {
        BoundHashOperations<String, String, String> hashOps = this.getOps(cacheGroup);
        return hashOps.hasKey((Object)cacheName);
    }

    @Override
    public Cache setCache(Cache cache) throws CacheException {
        Assert.notNull((Object)cache);
        Assert.notNull((Object)cache.getCacheGroup());
        Assert.notNull((Object)cache.getCacheName());
        Cache old = null;
        try {
            old = this.getCache(cache.getCacheGroup(), cache.getCacheValue());
        }
        catch (CacheException e) {
            logger.error("", (Throwable)e);
        }
        String redisConfigGroup = cache.getCacheGroup();
        BoundHashOperations<String, String, String> hashOps = this.getOps(redisConfigGroup);
        hashOps.put((Object)cache.getCacheName(), (Object)cache.getCacheValue());
        return old;
    }

    @Override
    public Boolean setExpire(String cacheGroup, long timeout, TimeUnit timeUnit) throws CacheException {
        Assert.notNull((Object)cacheGroup);
        BoundHashOperations hashOps = this.redisTemplate.boundHashOps((Object)cacheGroup);
        return hashOps.expire(timeout, timeUnit);
    }

    @Override
    public Cache getCache(String cacheGroup, String cacheName) throws CacheException {
        String value = this.getCacheValue(cacheGroup, cacheName);
        if (value == null) {
            return null;
        }
        return new Cache(cacheGroup, cacheName, value);
    }

    @Override
    public Collection<Cache> getCachesByGroup(String cacheGroup) throws CacheException {
        BoundHashOperations<String, String, String> hashOps = this.getOps(cacheGroup);
        Map map = hashOps.entries();
        Set entries = map.entrySet();
        HashSet<Cache> caches = new HashSet<Cache>(entries.size());
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Cache cache = new Cache(cacheGroup, key, value);
            caches.add(cache);
        }
        return caches;
    }

    @Override
    public Collection<String> getCacheValuesByGroup(String cacheGroup) throws CacheException {
        BoundHashOperations<String, String, String> ops = this.getOps(cacheGroup);
        List values = ops.values();
        return values;
    }

    @Override
    public String getCacheValue(String cacheGroup, String cacheName) throws CacheException {
        BoundHashOperations<String, String, String> hashOps = this.getOps(cacheGroup);
        String value = (String)hashOps.get((Object)cacheName);
        if (logger.isDebugEnabled()) {
            logger.debug("Return cache value: {} by cacheGroup: {} cacheName: {}", new Object[]{value, cacheGroup, cacheName});
        }
        return value;
    }

    @Override
    public boolean clearCachesByGroup(String cacheGroup) {
        if (!this.redisTemplate.hasKey((Object)cacheGroup).booleanValue()) {
            logger.info("Not found cacheGroup: {}, so ignored to clear it!", (Object)cacheGroup);
            return false;
        }
        this.redisTemplate.delete((Object)cacheGroup);
        if (logger.isDebugEnabled()) {
            logger.debug("Succeed delete cache: {}", (Object)cacheGroup);
        }
        return true;
    }

    @Override
    public boolean clearCachesByGroupPrefix(String cacheGroupPrefix) {
        Set keys = this.redisTemplate.keys((Object)(cacheGroupPrefix + "*"));
        if (CollectionUtils.isEmpty((Collection)keys)) {
            return false;
        }
        logger.info("Clear keys from redis: {}", (Object)keys);
        this.redisTemplate.delete((Collection)keys);
        return true;
    }

    public RedisTemplate<String, String> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

